/*
 * Decompiled with CFR 0.152.
 */
package org.tinymediamanager.jsonrpc.api.call;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.codehaus.jackson.JsonNode;
import org.codehaus.jackson.node.ArrayNode;
import org.codehaus.jackson.node.BooleanNode;
import org.codehaus.jackson.node.DoubleNode;
import org.codehaus.jackson.node.IntNode;
import org.codehaus.jackson.node.ObjectNode;
import org.codehaus.jackson.node.TextNode;
import org.tinymediamanager.jsonrpc.api.AbstractCall;
import org.tinymediamanager.jsonrpc.api.AbstractModel;
import org.tinymediamanager.jsonrpc.api.model.GlobalModel;
import org.tinymediamanager.jsonrpc.api.model.ListModel;
import org.tinymediamanager.jsonrpc.api.model.PlayerModel;
import org.tinymediamanager.jsonrpc.api.model.PlaylistModel;

public final class Player {

    public static class Zoom
    extends AbstractCall<String> {
        public static final String API_TYPE = "Player.Zoom";

        public Zoom(Integer n, String string) {
            this.addParameter("playerid", n);
            this.addParameter("zoom", string);
        }

        public Zoom(Integer n, Integer n2) {
            this.addParameter("playerid", n);
            this.addParameter("zoom", n2);
        }

        @Override
        protected String parseOne(JsonNode jsonNode) {
            return jsonNode.getTextValue();
        }

        @Override
        public String getName() {
            return API_TYPE;
        }

        @Override
        protected boolean returnsList() {
            return false;
        }

        public static interface ZoomValue {
            public static final String IN = "in";
            public static final String OUT = "out";
            public static final Set<String> values = new HashSet<String>(Arrays.asList("in", "out"));
        }
    }

    public static class Stop
    extends AbstractCall<String> {
        public static final String API_TYPE = "Player.Stop";

        public Stop(Integer n) {
            this.addParameter("playerid", n);
        }

        @Override
        protected String parseOne(JsonNode jsonNode) {
            return jsonNode.getTextValue();
        }

        @Override
        public String getName() {
            return API_TYPE;
        }

        @Override
        protected boolean returnsList() {
            return false;
        }
    }

    public static class SetSubtitle
    extends AbstractCall<String> {
        public static final String API_TYPE = "Player.SetSubtitle";

        public SetSubtitle(Integer n, String string, Boolean bl) {
            this.addParameter("playerid", n);
            this.addParameter("subtitle", string);
            this.addParameter("enable", bl);
        }

        public SetSubtitle(Integer n, Integer n2, Boolean bl) {
            this.addParameter("playerid", n);
            this.addParameter("subtitle", n2);
            this.addParameter("enable", bl);
        }

        public SetSubtitle(Integer n, String string) {
            this.addParameter("playerid", n);
            this.addParameter("subtitle", string);
        }

        public SetSubtitle(Integer n, Integer n2) {
            this.addParameter("playerid", n);
            this.addParameter("subtitle", n2);
        }

        @Override
        protected String parseOne(JsonNode jsonNode) {
            return jsonNode.getTextValue();
        }

        @Override
        public String getName() {
            return API_TYPE;
        }

        @Override
        protected boolean returnsList() {
            return false;
        }

        public static interface Subtitle {
            public static final String PREVIOUS = "previous";
            public static final String NEXT = "next";
            public static final String OFF = "off";
            public static final String ON = "on";
            public static final Set<String> values = new HashSet<String>(Arrays.asList("previous", "next", "off", "on"));
        }
    }

    public static class SetSpeed
    extends AbstractCall<PlayerModel.Speed> {
        public static final String API_TYPE = "Player.SetSpeed";

        public SetSpeed(Integer n, Integer n2) {
            this.addParameter("playerid", n);
            this.addParameter("speed", n2);
        }

        @Override
        protected PlayerModel.Speed parseOne(JsonNode jsonNode) {
            return new PlayerModel.Speed(jsonNode);
        }

        @Override
        public String getName() {
            return API_TYPE;
        }

        @Override
        protected boolean returnsList() {
            return false;
        }

        public static interface Speed {
            public static final Integer MINUS_32 = -32;
            public static final Integer MINUS_16 = -16;
            public static final Integer MINUS_8 = -8;
            public static final Integer MINUS_4 = -4;
            public static final Integer MINUS_2 = -2;
            public static final Integer MINUS_1 = -1;
            public static final Integer ZERO = 0;
            public static final Integer PLUS_1 = 1;
            public static final Integer PLUS_2 = 2;
            public static final Integer PLUS_4 = 4;
            public static final Integer PLUS_8 = 8;
            public static final Integer PLUS_16 = 16;
            public static final Integer PLUS_32 = 32;
            public static final Set<Integer> values = new HashSet<Integer>(Arrays.asList(MINUS_32, MINUS_16, MINUS_8, MINUS_4, MINUS_2, MINUS_1, ZERO, PLUS_1, PLUS_2, PLUS_4, PLUS_8, PLUS_16, PLUS_32));
        }
    }

    public static class SetShuffle
    extends AbstractCall<String> {
        public static final String API_TYPE = "Player.SetShuffle";

        public SetShuffle(Integer n, GlobalModel.Toggle toggle) {
            this.addParameter("playerid", n);
            this.addParameter("shuffle", (AbstractModel)toggle);
        }

        @Override
        protected String parseOne(JsonNode jsonNode) {
            return jsonNode.getTextValue();
        }

        @Override
        public String getName() {
            return API_TYPE;
        }

        @Override
        protected boolean returnsList() {
            return false;
        }
    }

    public static class SetRepeat
    extends AbstractCall<String> {
        public static final String API_TYPE = "Player.SetRepeat";

        public SetRepeat(Integer n, String string) {
            this.addParameter("playerid", n);
            this.addParameter("repeat", string);
        }

        @Override
        protected String parseOne(JsonNode jsonNode) {
            return jsonNode.getTextValue();
        }

        @Override
        public String getName() {
            return API_TYPE;
        }

        @Override
        protected boolean returnsList() {
            return false;
        }
    }

    public static class SetPartymode
    extends AbstractCall<String> {
        public static final String API_TYPE = "Player.SetPartymode";

        public SetPartymode(Integer n, GlobalModel.Toggle toggle) {
            this.addParameter("playerid", n);
            this.addParameter("partymode", (AbstractModel)toggle);
        }

        @Override
        protected String parseOne(JsonNode jsonNode) {
            return jsonNode.getTextValue();
        }

        @Override
        public String getName() {
            return API_TYPE;
        }

        @Override
        protected boolean returnsList() {
            return false;
        }
    }

    public static class SetAudioStream
    extends AbstractCall<String> {
        public static final String API_TYPE = "Player.SetAudioStream";

        public SetAudioStream(Integer n, String string) {
            this.addParameter("playerid", n);
            this.addParameter("stream", string);
        }

        public SetAudioStream(Integer n, Integer n2) {
            this.addParameter("playerid", n);
            this.addParameter("stream", n2);
        }

        @Override
        protected String parseOne(JsonNode jsonNode) {
            return jsonNode.getTextValue();
        }

        @Override
        public String getName() {
            return API_TYPE;
        }

        @Override
        protected boolean returnsList() {
            return false;
        }

        public static interface Stream {
            public static final String PREVIOUS = "previous";
            public static final String NEXT = "next";
            public static final Set<String> values = new HashSet<String>(Arrays.asList("previous", "next"));
        }
    }

    public static class Seek
    extends AbstractCall<SeekResult> {
        public static final String API_TYPE = "Player.Seek";

        public Seek(Integer n, Double d) {
            this.addParameter("playerid", n);
            this.addParameter("value", d);
        }

        public Seek(Integer n, PlayerModel.PositionTime positionTime) {
            this.addParameter("playerid", n);
            this.addParameter("value", (AbstractModel)positionTime);
        }

        public Seek(Integer n, String string) {
            this.addParameter("playerid", n);
            this.addParameter("value", string);
        }

        public Seek(Integer n, ValuePercentage valuePercentage) {
            this.addParameter("playerid", n);
            this.addParameter("value", (AbstractModel)valuePercentage);
        }

        public Seek(Integer n, ValueTime valueTime) {
            this.addParameter("playerid", n);
            this.addParameter("value", (AbstractModel)valueTime);
        }

        public Seek(Integer n, ValueStep valueStep) {
            this.addParameter("playerid", n);
            this.addParameter("value", (AbstractModel)valueStep);
        }

        public Seek(Integer n, ValueSecond valueSecond) {
            this.addParameter("playerid", n);
            this.addParameter("value", (AbstractModel)valueSecond);
        }

        @Override
        protected SeekResult parseOne(JsonNode jsonNode) {
            return new SeekResult(jsonNode);
        }

        @Override
        public String getName() {
            return API_TYPE;
        }

        @Override
        protected boolean returnsList() {
            return false;
        }

        public static interface Value {
            public static final String SMALLFORWARD = "smallforward";
            public static final String SMALLBACKWARD = "smallbackward";
            public static final String BIGFORWARD = "bigforward";
            public static final String BIGBACKWARD = "bigbackward";
            public static final Set<String> values = new HashSet<String>(Arrays.asList("smallforward", "smallbackward", "bigforward", "bigbackward"));
        }

        public static class SeekResult
        extends AbstractModel {
            public static final String PERCENTAGE = "percentage";
            public static final String TIME = "time";
            public static final String TOTALTIME = "totaltime";
            public final Double percentage;
            public final GlobalModel.Time time;
            public final GlobalModel.Time totaltime;

            public SeekResult(Double d, GlobalModel.Time time, GlobalModel.Time time2) {
                this.percentage = d;
                this.time = time;
                this.totaltime = time2;
            }

            public SeekResult(JsonNode jsonNode) {
                this.percentage = SeekResult.parseDouble(jsonNode, PERCENTAGE);
                this.time = jsonNode.has(TIME) ? new GlobalModel.Time(jsonNode.get(TIME)) : null;
                this.totaltime = jsonNode.has(TOTALTIME) ? new GlobalModel.Time(jsonNode.get(TOTALTIME)) : null;
            }

            @Override
            public JsonNode toJsonNode() {
                ObjectNode objectNode = OM.createObjectNode();
                objectNode.put(PERCENTAGE, this.percentage);
                objectNode.put(TIME, this.time == null ? null : this.time.toJsonNode());
                objectNode.put(TOTALTIME, this.totaltime == null ? null : this.totaltime.toJsonNode());
                return objectNode;
            }

            static List<SeekResult> getPlayerSeekResultList(JsonNode jsonNode, String string) {
                if (jsonNode.has(string)) {
                    ArrayNode arrayNode = (ArrayNode)jsonNode.get(string);
                    ArrayList<SeekResult> arrayList = new ArrayList<SeekResult>(arrayNode.size());
                    for (int i = 0; i < arrayNode.size(); ++i) {
                        arrayList.add(new SeekResult(arrayNode.get(i)));
                    }
                    return arrayList;
                }
                return new ArrayList<SeekResult>(0);
            }
        }

        public static class ValueSecond
        extends AbstractModel {
            public static final String SECONDS = "seconds";
            public final Integer seconds;

            public ValueSecond(Integer n) {
                this.seconds = n;
            }

            @Override
            public JsonNode toJsonNode() {
                ObjectNode objectNode = OM.createObjectNode();
                objectNode.put(SECONDS, this.seconds);
                return objectNode;
            }
        }

        public static class ValueStep
        extends AbstractModel {
            public static final String STEP = "step";
            public final String step;

            public ValueStep(String string) {
                this.step = string;
            }

            @Override
            public JsonNode toJsonNode() {
                ObjectNode objectNode = OM.createObjectNode();
                objectNode.put(STEP, this.step);
                return objectNode;
            }

            public static interface Step {
                public static final String SMALLFORWARD = "smallforward";
                public static final String SMALLBACKWARD = "smallbackward";
                public static final String BIGFORWARD = "bigforward";
                public static final String BIGBACKWARD = "bigbackward";
                public static final Set<String> values = new HashSet<String>(Arrays.asList("smallforward", "smallbackward", "bigforward", "bigbackward"));
            }
        }

        public static class ValueTime
        extends AbstractModel {
            public static final String TIME = "time";
            public final PlayerModel.PositionTime time;

            public ValueTime(PlayerModel.PositionTime positionTime) {
                this.time = positionTime;
            }

            @Override
            public JsonNode toJsonNode() {
                ObjectNode objectNode = OM.createObjectNode();
                objectNode.put(TIME, this.time == null ? null : this.time.toJsonNode());
                return objectNode;
            }
        }

        public static class ValuePercentage
        extends AbstractModel {
            public static final String PERCENTAGE = "percentage";
            public final Double percentage;

            public ValuePercentage(Double d) {
                this.percentage = d;
            }

            @Override
            public JsonNode toJsonNode() {
                ObjectNode objectNode = OM.createObjectNode();
                objectNode.put(PERCENTAGE, this.percentage);
                return objectNode;
            }
        }
    }

    public static class Rotate
    extends AbstractCall<String> {
        public static final String API_TYPE = "Player.Rotate";

        public Rotate(Integer n, String string) {
            this.addParameter("playerid", n);
            this.addParameter("value", string);
        }

        public Rotate(Integer n) {
            this.addParameter("playerid", n);
        }

        @Override
        protected String parseOne(JsonNode jsonNode) {
            return jsonNode.getTextValue();
        }

        @Override
        public String getName() {
            return API_TYPE;
        }

        @Override
        protected boolean returnsList() {
            return false;
        }

        public static interface Value {
            public static final String CLOCKWISE = "clockwise";
            public static final String COUNTERCLOCKWISE = "counterclockwise";
            public static final Set<String> values = new HashSet<String>(Arrays.asList("clockwise", "counterclockwise"));
        }
    }

    public static class PlayPause
    extends AbstractCall<PlayerModel.Speed> {
        public static final String API_TYPE = "Player.PlayPause";

        public PlayPause(Integer n, GlobalModel.Toggle toggle) {
            this.addParameter("playerid", n);
            this.addParameter("play", (AbstractModel)toggle);
        }

        public PlayPause(Integer n) {
            this.addParameter("playerid", n);
        }

        @Override
        protected PlayerModel.Speed parseOne(JsonNode jsonNode) {
            return new PlayerModel.Speed(jsonNode);
        }

        @Override
        public String getName() {
            return API_TYPE;
        }

        @Override
        protected boolean returnsList() {
            return false;
        }
    }

    public static class Open
    extends AbstractCall<String> {
        public static final String API_TYPE = "Player.Open";

        public Open(ItemPlaylistIdPosition itemPlaylistIdPosition, Option option) {
            this.addParameter("item", (AbstractModel)itemPlaylistIdPosition);
            this.addParameter("options", (AbstractModel)option);
        }

        public Open(PlaylistModel.Item item, Option option) {
            this.addParameter("item", (AbstractModel)item);
            this.addParameter("options", (AbstractModel)option);
        }

        public Open(ItemPathRandomRecursive itemPathRandomRecursive, Option option) {
            this.addParameter("item", (AbstractModel)itemPathRandomRecursive);
            this.addParameter("options", (AbstractModel)option);
        }

        public Open(ItemPartymode itemPartymode, Option option) {
            this.addParameter("item", (AbstractModel)itemPartymode);
            this.addParameter("options", (AbstractModel)option);
        }

        public Open(ItemChannelId itemChannelId, Option option) {
            this.addParameter("item", (AbstractModel)itemChannelId);
            this.addParameter("options", (AbstractModel)option);
        }

        public Open(ItemRecordingId itemRecordingId, Option option) {
            this.addParameter("item", (AbstractModel)itemRecordingId);
            this.addParameter("options", (AbstractModel)option);
        }

        public Open() {
        }

        public Open(ItemPlaylistIdPosition itemPlaylistIdPosition) {
            this.addParameter("item", (AbstractModel)itemPlaylistIdPosition);
        }

        public Open(PlaylistModel.Item item) {
            this.addParameter("item", (AbstractModel)item);
        }

        public Open(ItemPathRandomRecursive itemPathRandomRecursive) {
            this.addParameter("item", (AbstractModel)itemPathRandomRecursive);
        }

        public Open(ItemPartymode itemPartymode) {
            this.addParameter("item", (AbstractModel)itemPartymode);
        }

        public Open(ItemChannelId itemChannelId) {
            this.addParameter("item", (AbstractModel)itemChannelId);
        }

        public Open(ItemRecordingId itemRecordingId) {
            this.addParameter("item", (AbstractModel)itemRecordingId);
        }

        @Override
        protected String parseOne(JsonNode jsonNode) {
            return jsonNode.getTextValue();
        }

        @Override
        public String getName() {
            return API_TYPE;
        }

        @Override
        protected boolean returnsList() {
            return false;
        }

        public static class Option
        extends AbstractModel {
            public static final String PLAYERCOREID = "playercoreid";
            public static final String REPEAT = "repeat";
            public static final String RESUME = "resume";
            public static final String SHUFFLED = "shuffled";
            public final Playercoreid playercoreid;
            public final String repeat;
            public final Resume resume;
            public final Boolean shuffled;

            public Option(Playercoreid playercoreid, String string, Resume resume, Boolean bl) {
                this.playercoreid = playercoreid;
                this.repeat = string;
                this.resume = resume;
                this.shuffled = bl;
            }

            @Override
            public JsonNode toJsonNode() {
                ObjectNode objectNode = OM.createObjectNode();
                objectNode.put(PLAYERCOREID, this.playercoreid == null ? null : this.playercoreid.toJsonNode());
                objectNode.put(REPEAT, this.repeat);
                objectNode.put(RESUME, this.resume == null ? null : this.resume.toJsonNode());
                objectNode.put(SHUFFLED, this.shuffled);
                return objectNode;
            }

            public static class Playercoreid
            extends AbstractModel {
                public final Integer integerArg;
                public final String stringArg;

                public Playercoreid(Integer n) {
                    this.integerArg = n;
                    this.stringArg = null;
                }

                public Playercoreid(String string) {
                    this.stringArg = string;
                    this.integerArg = null;
                }

                @Override
                public JsonNode toJsonNode() {
                    if (this.integerArg != null) {
                        return new IntNode(this.integerArg.intValue());
                    }
                    if (this.stringArg != null) {
                        return new TextNode(this.stringArg);
                    }
                    return null;
                }

                public static interface StringArg {
                    public static final String DEFAULT = "default";
                    public static final Set<String> values = new HashSet<String>(Arrays.asList("default"));
                }
            }

            public static class Resume
            extends AbstractModel {
                public final Boolean booleanArg;
                public final Double positionPercentage;
                public final PlayerModel.PositionTime positionTime;

                public Resume(Boolean bl) {
                    this.booleanArg = bl;
                    this.positionPercentage = null;
                    this.positionTime = null;
                }

                public Resume(Double d) {
                    this.positionPercentage = d;
                    this.booleanArg = null;
                    this.positionTime = null;
                }

                public Resume(PlayerModel.PositionTime positionTime) {
                    this.positionTime = positionTime;
                    this.booleanArg = null;
                    this.positionPercentage = null;
                }

                @Override
                public JsonNode toJsonNode() {
                    if (this.booleanArg != null) {
                        return this.booleanArg != false ? BooleanNode.TRUE : BooleanNode.FALSE;
                    }
                    if (this.positionPercentage != null) {
                        return new DoubleNode(this.positionPercentage.doubleValue());
                    }
                    if (this.positionTime != null) {
                        return this.positionTime.toJsonNode();
                    }
                    return null;
                }
            }
        }

        public static class ItemRecordingId
        extends AbstractModel {
            public static final String RECORDINGID = "recordingid";
            public final Integer recordingid;

            public ItemRecordingId(Integer n) {
                this.recordingid = n;
            }

            @Override
            public JsonNode toJsonNode() {
                ObjectNode objectNode = OM.createObjectNode();
                objectNode.put(RECORDINGID, this.recordingid);
                return objectNode;
            }
        }

        public static class ItemChannelId
        extends AbstractModel {
            public static final String CHANNELID = "channelid";
            public final Integer channelid;

            public ItemChannelId(Integer n) {
                this.channelid = n;
            }

            @Override
            public JsonNode toJsonNode() {
                ObjectNode objectNode = OM.createObjectNode();
                objectNode.put(CHANNELID, this.channelid);
                return objectNode;
            }
        }

        public static class ItemPartymode
        extends AbstractModel {
            public static final String PARTYMODE = "partymode";
            public final String partymode;

            public ItemPartymode(String string) {
                this.partymode = string;
            }

            @Override
            public JsonNode toJsonNode() {
                ObjectNode objectNode = OM.createObjectNode();
                objectNode.put(PARTYMODE, this.partymode);
                return objectNode;
            }
        }

        public static class ItemPathRandomRecursive
        extends AbstractModel {
            public static final String PATH = "path";
            public static final String RANDOM = "random";
            public static final String RECURSIVE = "recursive";
            public final String path;
            public final Boolean random;
            public final Boolean recursive;

            public ItemPathRandomRecursive(String string, Boolean bl, Boolean bl2) {
                this.path = string;
                this.random = bl;
                this.recursive = bl2;
            }

            @Override
            public JsonNode toJsonNode() {
                ObjectNode objectNode = OM.createObjectNode();
                objectNode.put(PATH, this.path);
                objectNode.put(RANDOM, this.random);
                objectNode.put(RECURSIVE, this.recursive);
                return objectNode;
            }
        }

        public static class ItemPlaylistIdPosition
        extends AbstractModel {
            public static final String PLAYLISTID = "playlistid";
            public static final String POSITION = "position";
            public final Integer playlistid;
            public final Integer position;

            public ItemPlaylistIdPosition(Integer n, Integer n2) {
                this.playlistid = n;
                this.position = n2;
            }

            @Override
            public JsonNode toJsonNode() {
                ObjectNode objectNode = OM.createObjectNode();
                objectNode.put(PLAYLISTID, this.playlistid);
                objectNode.put(POSITION, this.position);
                return objectNode;
            }
        }
    }

    public static class Move
    extends AbstractCall<String> {
        public static final String API_TYPE = "Player.Move";

        public Move(Integer n, String string) {
            this.addParameter("playerid", n);
            this.addParameter("direction", string);
        }

        @Override
        protected String parseOne(JsonNode jsonNode) {
            return jsonNode.getTextValue();
        }

        @Override
        public String getName() {
            return API_TYPE;
        }

        @Override
        protected boolean returnsList() {
            return false;
        }

        public static interface Direction {
            public static final String LEFT = "left";
            public static final String RIGHT = "right";
            public static final String UP = "up";
            public static final String DOWN = "down";
            public static final Set<String> values = new HashSet<String>(Arrays.asList("left", "right", "up", "down"));
        }
    }

    public static class GoTo
    extends AbstractCall<String> {
        public static final String API_TYPE = "Player.GoTo";

        public GoTo(Integer n, String string) {
            this.addParameter("playerid", n);
            this.addParameter("to", string);
        }

        public GoTo(Integer n, Integer n2) {
            this.addParameter("playerid", n);
            this.addParameter("to", n2);
        }

        @Override
        protected String parseOne(JsonNode jsonNode) {
            return jsonNode.getTextValue();
        }

        @Override
        public String getName() {
            return API_TYPE;
        }

        @Override
        protected boolean returnsList() {
            return false;
        }

        public static interface To {
            public static final String PREVIOUS = "previous";
            public static final String NEXT = "next";
            public static final Set<String> values = new HashSet<String>(Arrays.asList("previous", "next"));
        }
    }

    public static class GetProperties
    extends AbstractCall<PlayerModel.PropertyValue> {
        public static final String API_TYPE = "Player.GetProperties";

        public GetProperties(Integer n, String ... stringArray) {
            this.addParameter("playerid", n);
            this.addParameter("properties", stringArray);
        }

        @Override
        protected PlayerModel.PropertyValue parseOne(JsonNode jsonNode) {
            return new PlayerModel.PropertyValue(jsonNode);
        }

        @Override
        public String getName() {
            return API_TYPE;
        }

        @Override
        protected boolean returnsList() {
            return false;
        }
    }

    public static class GetPlayers
    extends AbstractCall<GetPlayersResult> {
        public static final String API_TYPE = "Player.GetPlayers";

        public GetPlayers(String string) {
            this.addParameter("media", string);
        }

        @Override
        protected ArrayList<GetPlayersResult> parseMany(JsonNode jsonNode) {
            ArrayNode arrayNode = (ArrayNode)jsonNode;
            if (arrayNode != null) {
                ArrayList<GetPlayersResult> arrayList = new ArrayList<GetPlayersResult>(arrayNode.size());
                for (int i = 0; i < arrayNode.size(); ++i) {
                    ObjectNode objectNode = (ObjectNode)arrayNode.get(i);
                    arrayList.add(new GetPlayersResult((JsonNode)objectNode));
                }
                return arrayList;
            }
            return new ArrayList<GetPlayersResult>(0);
        }

        @Override
        public String getName() {
            return API_TYPE;
        }

        @Override
        protected boolean returnsList() {
            return true;
        }

        public static interface Media {
            public static final String ALL = "all";
            public static final String VIDEO = "video";
            public static final String AUDIO = "audio";
            public static final Set<String> values = new HashSet<String>(Arrays.asList("all", "video", "audio"));
        }

        public static class GetPlayersResult
        extends AbstractModel {
            public static final String NAME = "name";
            public static final String PLAYERCOREID = "playercoreid";
            public static final String PLAYSAUDIO = "playsaudio";
            public static final String PLAYSVIDEO = "playsvideo";
            public static final String TYPE = "type";
            public final String name;
            public final Integer playercoreid;
            public final Boolean playsaudio;
            public final Boolean playsvideo;
            public final String type;

            public GetPlayersResult(String string, Integer n, Boolean bl, Boolean bl2, String string2) {
                this.name = string;
                this.playercoreid = n;
                this.playsaudio = bl;
                this.playsvideo = bl2;
                this.type = string2;
            }

            public GetPlayersResult(JsonNode jsonNode) {
                this.name = GetPlayersResult.parseString(jsonNode, NAME);
                this.playercoreid = jsonNode.get(PLAYERCOREID).getIntValue();
                this.playsaudio = jsonNode.get(PLAYSAUDIO).getBooleanValue();
                this.playsvideo = jsonNode.get(PLAYSVIDEO).getBooleanValue();
                this.type = GetPlayersResult.parseString(jsonNode, TYPE);
            }

            @Override
            public JsonNode toJsonNode() {
                ObjectNode objectNode = OM.createObjectNode();
                objectNode.put(NAME, this.name);
                objectNode.put(PLAYERCOREID, this.playercoreid);
                objectNode.put(PLAYSAUDIO, this.playsaudio);
                objectNode.put(PLAYSVIDEO, this.playsvideo);
                objectNode.put(TYPE, this.type);
                return objectNode;
            }

            static List<GetPlayersResult> getPlayerGetPlayersResultList(JsonNode jsonNode, String string) {
                if (jsonNode.has(string)) {
                    ArrayNode arrayNode = (ArrayNode)jsonNode.get(string);
                    ArrayList<GetPlayersResult> arrayList = new ArrayList<GetPlayersResult>(arrayNode.size());
                    for (int i = 0; i < arrayNode.size(); ++i) {
                        arrayList.add(new GetPlayersResult(arrayNode.get(i)));
                    }
                    return arrayList;
                }
                return new ArrayList<GetPlayersResult>(0);
            }

            public static interface Type {
                public static final String INTERNAL = "internal";
                public static final String EXTERNAL = "external";
                public static final String REMOTE = "remote";
                public static final Set<String> values = new HashSet<String>(Arrays.asList("internal", "external", "remote"));
            }
        }
    }

    public static class GetItem
    extends AbstractCall<ListModel.AllItems> {
        public static final String API_TYPE = "Player.GetItem";
        public static final String RESULT = "item";

        public GetItem(Integer n, String ... stringArray) {
            this.addParameter("playerid", n);
            this.addParameter("properties", stringArray);
        }

        @Override
        protected ListModel.AllItems parseOne(JsonNode jsonNode) {
            return new ListModel.AllItems((JsonNode)((ObjectNode)jsonNode.get(RESULT)));
        }

        @Override
        public String getName() {
            return API_TYPE;
        }

        @Override
        protected boolean returnsList() {
            return false;
        }
    }

    public static class GetActivePlayers
    extends AbstractCall<GetActivePlayersResult> {
        public static final String API_TYPE = "Player.GetActivePlayers";

        @Override
        protected ArrayList<GetActivePlayersResult> parseMany(JsonNode jsonNode) {
            ArrayNode arrayNode = (ArrayNode)jsonNode;
            if (arrayNode != null) {
                ArrayList<GetActivePlayersResult> arrayList = new ArrayList<GetActivePlayersResult>(arrayNode.size());
                for (int i = 0; i < arrayNode.size(); ++i) {
                    ObjectNode objectNode = (ObjectNode)arrayNode.get(i);
                    arrayList.add(new GetActivePlayersResult((JsonNode)objectNode));
                }
                return arrayList;
            }
            return new ArrayList<GetActivePlayersResult>(0);
        }

        @Override
        public String getName() {
            return API_TYPE;
        }

        @Override
        protected boolean returnsList() {
            return true;
        }

        public static class GetActivePlayersResult
        extends AbstractModel {
            public static final String PLAYERID = "playerid";
            public static final String TYPE = "type";
            public final Integer playerid;
            public final String type;

            public GetActivePlayersResult(Integer n, String string) {
                this.playerid = n;
                this.type = string;
            }

            public GetActivePlayersResult(JsonNode jsonNode) {
                this.playerid = GetActivePlayersResult.parseInt(jsonNode, PLAYERID);
                this.type = GetActivePlayersResult.parseString(jsonNode, TYPE);
            }

            @Override
            public JsonNode toJsonNode() {
                ObjectNode objectNode = OM.createObjectNode();
                objectNode.put(PLAYERID, this.playerid);
                objectNode.put(TYPE, this.type);
                return objectNode;
            }

            static List<GetActivePlayersResult> getPlayerGetActivePlayersResultList(JsonNode jsonNode, String string) {
                if (jsonNode.has(string)) {
                    ArrayNode arrayNode = (ArrayNode)jsonNode.get(string);
                    ArrayList<GetActivePlayersResult> arrayList = new ArrayList<GetActivePlayersResult>(arrayNode.size());
                    for (int i = 0; i < arrayNode.size(); ++i) {
                        arrayList.add(new GetActivePlayersResult(arrayNode.get(i)));
                    }
                    return arrayList;
                }
                return new ArrayList<GetActivePlayersResult>(0);
            }

            public static interface Type {
                public static final String VIDEO = "video";
                public static final String AUDIO = "audio";
                public static final String PICTURE = "picture";
                public static final Set<String> values = new HashSet<String>(Arrays.asList("video", "audio", "picture"));
            }
        }
    }
}

