/*
 * Decompiled with CFR 0.152.
 */
package org.tinymediamanager.jsonrpc.api.model;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.codehaus.jackson.JsonNode;
import org.codehaus.jackson.node.ArrayNode;
import org.codehaus.jackson.node.BooleanNode;
import org.codehaus.jackson.node.ObjectNode;
import org.codehaus.jackson.node.TextNode;
import org.tinymediamanager.jsonrpc.api.AbstractModel;
import org.tinymediamanager.jsonrpc.api.model.ItemModel;

public final class AddonModel {

    public static interface Types {
        public static final String UNKNOWN = "unknown";
        public static final String XBMC_PLAYER_MUSICVIZ = "xbmc.player.musicviz";
        public static final String XBMC_GUI_SKIN = "xbmc.gui.skin";
        public static final String XBMC_PVRCLIENT = "xbmc.pvrclient";
        public static final String KODI_ADSP = "kodi.adsp";
        public static final String XBMC_PYTHON_SCRIPT = "xbmc.python.script";
        public static final String XBMC_PYTHON_WEATHER = "xbmc.python.weather";
        public static final String XBMC_SUBTITLE_MODULE = "xbmc.subtitle.module";
        public static final String XBMC_PYTHON_LYRICS = "xbmc.python.lyrics";
        public static final String XBMC_METADATA_SCRAPER_ALBUMS = "xbmc.metadata.scraper.albums";
        public static final String XBMC_METADATA_SCRAPER_ARTISTS = "xbmc.metadata.scraper.artists";
        public static final String XBMC_METADATA_SCRAPER_MOVIES = "xbmc.metadata.scraper.movies";
        public static final String XBMC_METADATA_SCRAPER_MUSICVIDEOS = "xbmc.metadata.scraper.musicvideos";
        public static final String XBMC_METADATA_SCRAPER_TVSHOWS = "xbmc.metadata.scraper.tvshows";
        public static final String XBMC_UI_SCREENSAVER = "xbmc.ui.screensaver";
        public static final String XBMC_PYTHON_PLUGINSOURCE = "xbmc.python.pluginsource";
        public static final String XBMC_ADDON_REPOSITORY = "xbmc.addon.repository";
        public static final String XBMC_WEBINTERFACE = "xbmc.webinterface";
        public static final String XBMC_SERVICE = "xbmc.service";
        public static final String XBMC_AUDIOENCODER = "xbmc.audioencoder";
        public static final String KODI_CONTEXT_ITEM = "kodi.context.item";
        public static final String KODI_AUDIODECODER = "kodi.audiodecoder";
        public static final String KODI_RESOURCE_IMAGES = "kodi.resource.images";
        public static final String KODI_RESOURCE_LANGUAGE = "kodi.resource.language";
        public static final String KODI_RESOURCE_UISOUNDS = "kodi.resource.uisounds";
        public static final String XBMC_ADDON_VIDEO = "xbmc.addon.video";
        public static final String XBMC_ADDON_AUDIO = "xbmc.addon.audio";
        public static final String XBMC_ADDON_IMAGE = "xbmc.addon.image";
        public static final String XBMC_ADDON_EXECUTABLE = "xbmc.addon.executable";
        public static final String VISUALIZATION_LIBRARY = "visualization-library";
        public static final String XBMC_METADATA_SCRAPER_LIBRARY = "xbmc.metadata.scraper.library";
        public static final String XBMC_PYTHON_LIBRARY = "xbmc.python.library";
        public static final String XBMC_PYTHON_MODULE = "xbmc.python.module";
        public static final Set<String> values = new HashSet<String>(Arrays.asList("unknown", "xbmc.player.musicviz", "xbmc.gui.skin", "xbmc.pvrclient", "kodi.adsp", "xbmc.python.script", "xbmc.python.weather", "xbmc.subtitle.module", "xbmc.python.lyrics", "xbmc.metadata.scraper.albums", "xbmc.metadata.scraper.artists", "xbmc.metadata.scraper.movies", "xbmc.metadata.scraper.musicvideos", "xbmc.metadata.scraper.tvshows", "xbmc.ui.screensaver", "xbmc.python.pluginsource", "xbmc.addon.repository", "xbmc.webinterface", "xbmc.service", "xbmc.audioencoder", "kodi.context.item", "kodi.audiodecoder", "kodi.resource.images", "kodi.resource.language", "kodi.resource.uisounds", "xbmc.addon.video", "xbmc.addon.audio", "xbmc.addon.image", "xbmc.addon.executable", "visualization-library", "xbmc.metadata.scraper.library", "xbmc.python.library", "xbmc.python.module"));
    }

    public static interface Fields {
        public static final String NAME = "name";
        public static final String VERSION = "version";
        public static final String SUMMARY = "summary";
        public static final String DESCRIPTION = "description";
        public static final String PATH = "path";
        public static final String AUTHOR = "author";
        public static final String THUMBNAIL = "thumbnail";
        public static final String DISCLAIMER = "disclaimer";
        public static final String FANART = "fanart";
        public static final String DEPENDENCIES = "dependencies";
        public static final String BROKEN = "broken";
        public static final String EXTRAINFO = "extrainfo";
        public static final String RATING = "rating";
        public static final String ENABLED = "enabled";
        public static final Set<String> values = new HashSet<String>(Arrays.asList("name", "version", "summary", "description", "path", "author", "thumbnail", "disclaimer", "fanart", "dependencies", "broken", "extrainfo", "rating", "enabled"));
    }

    public static interface Content {
        public static final String UNKNOWN = "unknown";
        public static final String VIDEO = "video";
        public static final String AUDIO = "audio";
        public static final String IMAGE = "image";
        public static final String EXECUTABLE = "executable";
        public static final Set<String> values = new HashSet<String>(Arrays.asList("unknown", "video", "audio", "image", "executable"));
    }

    public static class Detail
    extends ItemModel.BaseDetail {
        public static final String API_TYPE = "Addon.Details";
        public static final String ADDONID = "addonid";
        public static final String AUTHOR = "author";
        public static final String BROKEN = "broken";
        public static final String DEPENDENCIES = "dependencies";
        public static final String DESCRIPTION = "description";
        public static final String DISCLAIMER = "disclaimer";
        public static final String ENABLED = "enabled";
        public static final String EXTRAINFO = "extrainfo";
        public static final String FANART = "fanart";
        public static final String NAME = "name";
        public static final String PATH = "path";
        public static final String RATING = "rating";
        public static final String SUMMARY = "summary";
        public static final String THUMBNAIL = "thumbnail";
        public static final String TYPE = "type";
        public static final String VERSION = "version";
        public final String addonid;
        public final String author;
        public final Broken broken;
        public final List<Dependency> dependencies;
        public final String description;
        public final String disclaimer;
        public final Boolean enabled;
        public final List<Extrainfo> extrainfo;
        public final String fanart;
        public final String name;
        public final String path;
        public final Integer rating;
        public final String summary;
        public final String thumbnail;
        public final String type;
        public final String version;

        public Detail(JsonNode jsonNode) {
            super(jsonNode);
            this.addonid = jsonNode.get(ADDONID).getTextValue();
            this.author = Detail.parseString(jsonNode, AUTHOR);
            this.broken = jsonNode.has(BROKEN) ? new Broken(jsonNode.get(BROKEN)) : null;
            this.dependencies = Dependency.getAddonModelDependencyList(jsonNode, DEPENDENCIES);
            this.description = Detail.parseString(jsonNode, DESCRIPTION);
            this.disclaimer = Detail.parseString(jsonNode, DISCLAIMER);
            this.enabled = Detail.parseBoolean(jsonNode, ENABLED);
            this.extrainfo = Extrainfo.getAddonModelExtrainfoList(jsonNode, EXTRAINFO);
            this.fanart = Detail.parseString(jsonNode, FANART);
            this.name = Detail.parseString(jsonNode, NAME);
            this.path = Detail.parseString(jsonNode, PATH);
            this.rating = Detail.parseInt(jsonNode, RATING);
            this.summary = Detail.parseString(jsonNode, SUMMARY);
            this.thumbnail = Detail.parseString(jsonNode, THUMBNAIL);
            this.type = Detail.parseString(jsonNode, TYPE);
            this.version = Detail.parseString(jsonNode, VERSION);
        }

        @Override
        public JsonNode toJsonNode() {
            ObjectNode objectNode = (ObjectNode)super.toJsonNode();
            objectNode.put(ADDONID, this.addonid);
            objectNode.put(AUTHOR, this.author);
            objectNode.put(BROKEN, this.broken == null ? null : this.broken.toJsonNode());
            ArrayNode arrayNode = OM.createArrayNode();
            for (Dependency object : this.dependencies) {
                arrayNode.add(object.toJsonNode());
            }
            objectNode.put(DEPENDENCIES, (JsonNode)arrayNode);
            objectNode.put(DESCRIPTION, this.description);
            objectNode.put(DISCLAIMER, this.disclaimer);
            objectNode.put(ENABLED, this.enabled);
            ArrayNode arrayNode2 = OM.createArrayNode();
            for (Extrainfo extrainfo : this.extrainfo) {
                arrayNode2.add(extrainfo.toJsonNode());
            }
            objectNode.put(EXTRAINFO, (JsonNode)arrayNode2);
            objectNode.put(FANART, this.fanart);
            objectNode.put(NAME, this.name);
            objectNode.put(PATH, this.path);
            objectNode.put(RATING, this.rating);
            objectNode.put(SUMMARY, this.summary);
            objectNode.put(THUMBNAIL, this.thumbnail);
            objectNode.put(TYPE, this.type);
            objectNode.put(VERSION, this.version);
            return objectNode;
        }

        static List<Detail> getAddonModelDetailList(JsonNode jsonNode, String string) {
            if (jsonNode.has(string)) {
                ArrayNode arrayNode = (ArrayNode)jsonNode.get(string);
                ArrayList<Detail> arrayList = new ArrayList<Detail>(arrayNode.size());
                for (int i = 0; i < arrayNode.size(); ++i) {
                    arrayList.add(new Detail(arrayNode.get(i)));
                }
                return arrayList;
            }
            return new ArrayList<Detail>(0);
        }

        public static interface Type {
            public static final String UNKNOWN = "unknown";
            public static final String XBMC_PLAYER_MUSICVIZ = "xbmc.player.musicviz";
            public static final String XBMC_GUI_SKIN = "xbmc.gui.skin";
            public static final String XBMC_PVRCLIENT = "xbmc.pvrclient";
            public static final String KODI_ADSP = "kodi.adsp";
            public static final String XBMC_PYTHON_SCRIPT = "xbmc.python.script";
            public static final String XBMC_PYTHON_WEATHER = "xbmc.python.weather";
            public static final String XBMC_SUBTITLE_MODULE = "xbmc.subtitle.module";
            public static final String XBMC_PYTHON_LYRICS = "xbmc.python.lyrics";
            public static final String XBMC_METADATA_SCRAPER_ALBUMS = "xbmc.metadata.scraper.albums";
            public static final String XBMC_METADATA_SCRAPER_ARTISTS = "xbmc.metadata.scraper.artists";
            public static final String XBMC_METADATA_SCRAPER_MOVIES = "xbmc.metadata.scraper.movies";
            public static final String XBMC_METADATA_SCRAPER_MUSICVIDEOS = "xbmc.metadata.scraper.musicvideos";
            public static final String XBMC_METADATA_SCRAPER_TVSHOWS = "xbmc.metadata.scraper.tvshows";
            public static final String XBMC_UI_SCREENSAVER = "xbmc.ui.screensaver";
            public static final String XBMC_PYTHON_PLUGINSOURCE = "xbmc.python.pluginsource";
            public static final String XBMC_ADDON_REPOSITORY = "xbmc.addon.repository";
            public static final String XBMC_WEBINTERFACE = "xbmc.webinterface";
            public static final String XBMC_SERVICE = "xbmc.service";
            public static final String XBMC_AUDIOENCODER = "xbmc.audioencoder";
            public static final String KODI_CONTEXT_ITEM = "kodi.context.item";
            public static final String KODI_AUDIODECODER = "kodi.audiodecoder";
            public static final String KODI_RESOURCE_IMAGES = "kodi.resource.images";
            public static final String KODI_RESOURCE_LANGUAGE = "kodi.resource.language";
            public static final String KODI_RESOURCE_UISOUNDS = "kodi.resource.uisounds";
            public static final String XBMC_ADDON_VIDEO = "xbmc.addon.video";
            public static final String XBMC_ADDON_AUDIO = "xbmc.addon.audio";
            public static final String XBMC_ADDON_IMAGE = "xbmc.addon.image";
            public static final String XBMC_ADDON_EXECUTABLE = "xbmc.addon.executable";
            public static final String VISUALIZATION_LIBRARY = "visualization-library";
            public static final String XBMC_METADATA_SCRAPER_LIBRARY = "xbmc.metadata.scraper.library";
            public static final String XBMC_PYTHON_LIBRARY = "xbmc.python.library";
            public static final String XBMC_PYTHON_MODULE = "xbmc.python.module";
            public static final Set<String> values = new HashSet<String>(Arrays.asList("unknown", "xbmc.player.musicviz", "xbmc.gui.skin", "xbmc.pvrclient", "kodi.adsp", "xbmc.python.script", "xbmc.python.weather", "xbmc.subtitle.module", "xbmc.python.lyrics", "xbmc.metadata.scraper.albums", "xbmc.metadata.scraper.artists", "xbmc.metadata.scraper.movies", "xbmc.metadata.scraper.musicvideos", "xbmc.metadata.scraper.tvshows", "xbmc.ui.screensaver", "xbmc.python.pluginsource", "xbmc.addon.repository", "xbmc.webinterface", "xbmc.service", "xbmc.audioencoder", "kodi.context.item", "kodi.audiodecoder", "kodi.resource.images", "kodi.resource.language", "kodi.resource.uisounds", "xbmc.addon.video", "xbmc.addon.audio", "xbmc.addon.image", "xbmc.addon.executable", "visualization-library", "xbmc.metadata.scraper.library", "xbmc.python.library", "xbmc.python.module"));
        }

        public static class Extrainfo
        extends AbstractModel {
            public static final String KEY = "key";
            public static final String VALUE = "value";
            public final String key;
            public final String value;

            public Extrainfo(String string, String string2) {
                this.key = string;
                this.value = string2;
            }

            public Extrainfo(JsonNode jsonNode) {
                this.key = jsonNode.get(KEY).getTextValue();
                this.value = jsonNode.get(VALUE).getTextValue();
            }

            @Override
            public JsonNode toJsonNode() {
                ObjectNode objectNode = OM.createObjectNode();
                objectNode.put(KEY, this.key);
                objectNode.put(VALUE, this.value);
                return objectNode;
            }

            static List<Extrainfo> getAddonModelExtrainfoList(JsonNode jsonNode, String string) {
                if (jsonNode.has(string)) {
                    ArrayNode arrayNode = (ArrayNode)jsonNode.get(string);
                    ArrayList<Extrainfo> arrayList = new ArrayList<Extrainfo>(arrayNode.size());
                    for (int i = 0; i < arrayNode.size(); ++i) {
                        arrayList.add(new Extrainfo(arrayNode.get(i)));
                    }
                    return arrayList;
                }
                return new ArrayList<Extrainfo>(0);
            }
        }

        public static class Dependency
        extends AbstractModel {
            public static final String ADDONID = "addonid";
            public static final String OPTIONAL = "optional";
            public static final String VERSION = "version";
            public final String addonid;
            public final Boolean optional;
            public final String version;

            public Dependency(String string, Boolean bl, String string2) {
                this.addonid = string;
                this.optional = bl;
                this.version = string2;
            }

            public Dependency(JsonNode jsonNode) {
                this.addonid = jsonNode.get("addonid").getTextValue();
                this.optional = jsonNode.get(OPTIONAL).getBooleanValue();
                this.version = jsonNode.get("version").getTextValue();
            }

            @Override
            public JsonNode toJsonNode() {
                ObjectNode objectNode = OM.createObjectNode();
                objectNode.put("addonid", this.addonid);
                objectNode.put(OPTIONAL, this.optional);
                objectNode.put("version", this.version);
                return objectNode;
            }

            static List<Dependency> getAddonModelDependencyList(JsonNode jsonNode, String string) {
                if (jsonNode.has(string)) {
                    ArrayNode arrayNode = (ArrayNode)jsonNode.get(string);
                    ArrayList<Dependency> arrayList = new ArrayList<Dependency>(arrayNode.size());
                    for (int i = 0; i < arrayNode.size(); ++i) {
                        arrayList.add(new Dependency(arrayNode.get(i)));
                    }
                    return arrayList;
                }
                return new ArrayList<Dependency>(0);
            }
        }

        public static class Broken
        extends AbstractModel {
            public final Boolean booleanArg;
            public final String stringArg;

            public Broken(Boolean bl) {
                this.booleanArg = bl;
                this.stringArg = null;
            }

            public Broken(String string) {
                this.stringArg = string;
                this.booleanArg = null;
            }

            public Broken(JsonNode jsonNode) {
                if (jsonNode.isBoolean()) {
                    this.booleanArg = jsonNode.getBooleanValue();
                    this.stringArg = null;
                } else if (jsonNode.isTextual()) {
                    this.stringArg = jsonNode.getTextValue();
                    this.booleanArg = null;
                } else {
                    throw new RuntimeException("Weird type for \"broken\", I'm confused!");
                }
            }

            @Override
            public JsonNode toJsonNode() {
                if (this.booleanArg != null) {
                    return this.booleanArg != false ? BooleanNode.TRUE : BooleanNode.FALSE;
                }
                if (this.stringArg != null) {
                    return new TextNode(this.stringArg);
                }
                return null;
            }

            static List<Broken> getAddonModelBrokenList(JsonNode jsonNode, String string) {
                if (jsonNode.has(string)) {
                    ArrayNode arrayNode = (ArrayNode)jsonNode.get(string);
                    ArrayList<Broken> arrayList = new ArrayList<Broken>(arrayNode.size());
                    for (int i = 0; i < arrayNode.size(); ++i) {
                        arrayList.add(new Broken(arrayNode.get(i)));
                    }
                    return arrayList;
                }
                return new ArrayList<Broken>(0);
            }
        }
    }
}

