/*
 * Decompiled with CFR 0.152.
 */
package org.tinymediamanager.jsonrpc.api.model;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.codehaus.jackson.JsonNode;
import org.codehaus.jackson.node.ArrayNode;
import org.codehaus.jackson.node.ObjectNode;
import org.tinymediamanager.jsonrpc.api.AbstractModel;

public final class GUIModel {

    public static interface Window {
        public static final String HOME = "home";
        public static final String PROGRAMS = "programs";
        public static final String PICTURES = "pictures";
        public static final String FILEMANAGER = "filemanager";
        public static final String FILES = "files";
        public static final String SETTINGS = "settings";
        public static final String MUSIC = "music";
        public static final String VIDEO = "video";
        public static final String VIDEOS = "videos";
        public static final String PVR = "pvr";
        public static final String TVCHANNELS = "tvchannels";
        public static final String TVRECORDINGS = "tvrecordings";
        public static final String TVGUIDE = "tvguide";
        public static final String TVTIMERS = "tvtimers";
        public static final String TVSEARCH = "tvsearch";
        public static final String RADIOCHANNELS = "radiochannels";
        public static final String RADIORECORDINGS = "radiorecordings";
        public static final String RADIOGUIDE = "radioguide";
        public static final String RADIOTIMERS = "radiotimers";
        public static final String RADIOSEARCH = "radiosearch";
        public static final String PVRGUIDEINFO = "pvrguideinfo";
        public static final String PVRRECORDINGINFO = "pvrrecordinginfo";
        public static final String PVRRADIORDSINFO = "pvrradiordsinfo";
        public static final String PVRTIMERSETTING = "pvrtimersetting";
        public static final String PVRGROUPMANAGER = "pvrgroupmanager";
        public static final String PVRCHANNELMANAGER = "pvrchannelmanager";
        public static final String PVRGUIDESEARCH = "pvrguidesearch";
        public static final String PVRCHANNELSCAN = "pvrchannelscan";
        public static final String PVRUPDATEPROGRESS = "pvrupdateprogress";
        public static final String PVROSDCHANNELS = "pvrosdchannels";
        public static final String PVROSDGUIDE = "pvrosdguide";
        public static final String PVROSDTELETEXT = "pvrosdteletext";
        public static final String SYSTEMINFO = "systeminfo";
        public static final String TESTPATTERN = "testpattern";
        public static final String SCREENCALIBRATION = "screencalibration";
        public static final String GUICALIBRATION = "guicalibration";
        public static final String PICTURESSETTINGS = "picturessettings";
        public static final String PROGRAMSSETTINGS = "programssettings";
        public static final String WEATHERSETTINGS = "weathersettings";
        public static final String MUSICSETTINGS = "musicsettings";
        public static final String SYSTEMSETTINGS = "systemsettings";
        public static final String VIDEOSSETTINGS = "videossettings";
        public static final String NETWORKSETTINGS = "networksettings";
        public static final String SERVICESETTINGS = "servicesettings";
        public static final String APPEARANCESETTINGS = "appearancesettings";
        public static final String PVRSETTINGS = "pvrsettings";
        public static final String TVSETTINGS = "tvsettings";
        public static final String SCRIPTS = "scripts";
        public static final String VIDEOFILES = "videofiles";
        public static final String VIDEOLIBRARY = "videolibrary";
        public static final String VIDEOPLAYLIST = "videoplaylist";
        public static final String LOGINSCREEN = "loginscreen";
        public static final String PROFILES = "profiles";
        public static final String SKINSETTINGS = "skinsettings";
        public static final String ADDONBROWSER = "addonbrowser";
        public static final String YESNODIALOG = "yesnodialog";
        public static final String PROGRESSDIALOG = "progressdialog";
        public static final String VIRTUALKEYBOARD = "virtualkeyboard";
        public static final String VOLUMEBAR = "volumebar";
        public static final String SUBMENU = "submenu";
        public static final String FAVOURITES = "favourites";
        public static final String CONTEXTMENU = "contextmenu";
        public static final String INFODIALOG = "infodialog";
        public static final String NUMERICINPUT = "numericinput";
        public static final String GAMEPADINPUT = "gamepadinput";
        public static final String SHUTDOWNMENU = "shutdownmenu";
        public static final String MUTEBUG = "mutebug";
        public static final String PLAYERCONTROLS = "playercontrols";
        public static final String SEEKBAR = "seekbar";
        public static final String MUSICOSD = "musicosd";
        public static final String ADDONSETTINGS = "addonsettings";
        public static final String VISUALISATIONSETTINGS = "visualisationsettings";
        public static final String VISUALISATIONPRESETLIST = "visualisationpresetlist";
        public static final String OSDVIDEOSETTINGS = "osdvideosettings";
        public static final String OSDAUDIOSETTINGS = "osdaudiosettings";
        public static final String AUDIODSPMANAGER = "audiodspmanager";
        public static final String OSDAUDIODSPSETTINGS = "osdaudiodspsettings";
        public static final String VIDEOBOOKMARKS = "videobookmarks";
        public static final String FILEBROWSER = "filebrowser";
        public static final String NETWORKSETUP = "networksetup";
        public static final String MEDIASOURCE = "mediasource";
        public static final String PROFILESETTINGS = "profilesettings";
        public static final String LOCKSETTINGS = "locksettings";
        public static final String CONTENTSETTINGS = "contentsettings";
        public static final String SONGINFORMATION = "songinformation";
        public static final String SMARTPLAYLISTEDITOR = "smartplaylisteditor";
        public static final String SMARTPLAYLISTRULE = "smartplaylistrule";
        public static final String BUSYDIALOG = "busydialog";
        public static final String PICTUREINFO = "pictureinfo";
        public static final String ACCESSPOINTS = "accesspoints";
        public static final String FULLSCREENINFO = "fullscreeninfo";
        public static final String SLIDERDIALOG = "sliderdialog";
        public static final String ADDONINFORMATION = "addoninformation";
        public static final String SUBTITLESEARCH = "subtitlesearch";
        public static final String MUSICPLAYLIST = "musicplaylist";
        public static final String MUSICFILES = "musicfiles";
        public static final String MUSICLIBRARY = "musiclibrary";
        public static final String MUSICPLAYLISTEDITOR = "musicplaylisteditor";
        public static final String TELETEXT = "teletext";
        public static final String SELECTDIALOG = "selectdialog";
        public static final String MUSICINFORMATION = "musicinformation";
        public static final String OKDIALOG = "okdialog";
        public static final String MOVIEINFORMATION = "movieinformation";
        public static final String TEXTVIEWER = "textviewer";
        public static final String FULLSCREENVIDEO = "fullscreenvideo";
        public static final String FULLSCREENLIVETV = "fullscreenlivetv";
        public static final String FULLSCREENRADIO = "fullscreenradio";
        public static final String VISUALISATION = "visualisation";
        public static final String SLIDESHOW = "slideshow";
        public static final String WEATHER = "weather";
        public static final String SCREENSAVER = "screensaver";
        public static final String VIDEOOSD = "videoosd";
        public static final String VIDEOMENU = "videomenu";
        public static final String VIDEOTIMESEEK = "videotimeseek";
        public static final String STARTWINDOW = "startwindow";
        public static final String STARTUP = "startup";
        public static final String PERIPHERALSETTINGS = "peripheralsettings";
        public static final String EXTENDEDPROGRESSDIALOG = "extendedprogressdialog";
        public static final String MEDIAFILTER = "mediafilter";
        public static final String ADDON = "addon";
        public static final String EVENTLOG = "eventlog";
        public static final Set<String> values = new HashSet<String>(Arrays.asList("home", "programs", "pictures", "filemanager", "files", "settings", "music", "video", "videos", "pvr", "tvchannels", "tvrecordings", "tvguide", "tvtimers", "tvsearch", "radiochannels", "radiorecordings", "radioguide", "radiotimers", "radiosearch", "pvrguideinfo", "pvrrecordinginfo", "pvrradiordsinfo", "pvrtimersetting", "pvrgroupmanager", "pvrchannelmanager", "pvrguidesearch", "pvrchannelscan", "pvrupdateprogress", "pvrosdchannels", "pvrosdguide", "pvrosdteletext", "systeminfo", "testpattern", "screencalibration", "guicalibration", "picturessettings", "programssettings", "weathersettings", "musicsettings", "systemsettings", "videossettings", "networksettings", "servicesettings", "appearancesettings", "pvrsettings", "tvsettings", "scripts", "videofiles", "videolibrary", "videoplaylist", "loginscreen", "profiles", "skinsettings", "addonbrowser", "yesnodialog", "progressdialog", "virtualkeyboard", "volumebar", "submenu", "favourites", "contextmenu", "infodialog", "numericinput", "gamepadinput", "shutdownmenu", "mutebug", "playercontrols", "seekbar", "musicosd", "addonsettings", "visualisationsettings", "visualisationpresetlist", "osdvideosettings", "osdaudiosettings", "audiodspmanager", "osdaudiodspsettings", "videobookmarks", "filebrowser", "networksetup", "mediasource", "profilesettings", "locksettings", "contentsettings", "songinformation", "smartplaylisteditor", "smartplaylistrule", "busydialog", "pictureinfo", "accesspoints", "fullscreeninfo", "sliderdialog", "addoninformation", "subtitlesearch", "musicplaylist", "musicfiles", "musiclibrary", "musicplaylisteditor", "teletext", "selectdialog", "musicinformation", "okdialog", "movieinformation", "textviewer", "fullscreenvideo", "fullscreenlivetv", "fullscreenradio", "visualisation", "slideshow", "weather", "screensaver", "videoosd", "videomenu", "videotimeseek", "startwindow", "startup", "peripheralsettings", "extendedprogressdialog", "mediafilter", "addon", "eventlog"));
    }

    public static interface PropertyName {
        public static final String CURRENTWINDOW = "currentwindow";
        public static final String CURRENTCONTROL = "currentcontrol";
        public static final String SKIN = "skin";
        public static final String FULLSCREEN = "fullscreen";
        public static final String STEREOSCOPICMODE = "stereoscopicmode";
        public static final Set<String> values = new HashSet<String>(Arrays.asList("currentwindow", "currentcontrol", "skin", "fullscreen", "stereoscopicmode"));
    }

    public static class StereoscopyMode
    extends AbstractModel {
        public static final String API_TYPE = "GUI.Stereoscopy.Mode";
        public static final String LABEL = "label";
        public static final String MODE = "mode";
        public final String label;
        public final String mode;

        public StereoscopyMode(String string, String string2) {
            this.label = string;
            this.mode = string2;
        }

        public StereoscopyMode(JsonNode jsonNode) {
            this.label = jsonNode.get(LABEL).getTextValue();
            this.mode = StereoscopyMode.parseString(jsonNode, MODE);
        }

        @Override
        public JsonNode toJsonNode() {
            ObjectNode objectNode = OM.createObjectNode();
            objectNode.put(LABEL, this.label);
            objectNode.put(MODE, this.mode);
            return objectNode;
        }

        static List<StereoscopyMode> getGUIModelStereoscopyModeList(JsonNode jsonNode, String string) {
            if (jsonNode.has(string)) {
                ArrayNode arrayNode = (ArrayNode)jsonNode.get(string);
                ArrayList<StereoscopyMode> arrayList = new ArrayList<StereoscopyMode>(arrayNode.size());
                for (int i = 0; i < arrayNode.size(); ++i) {
                    arrayList.add(new StereoscopyMode(arrayNode.get(i)));
                }
                return arrayList;
            }
            return new ArrayList<StereoscopyMode>(0);
        }

        public static interface Mode {
            public static final String OFF = "off";
            public static final String SPLIT_VERTICAL = "split_vertical";
            public static final String SPLIT_HORIZONTAL = "split_horizontal";
            public static final String ROW_INTERLEAVED = "row_interleaved";
            public static final String HARDWARE_BASED = "hardware_based";
            public static final String ANAGLYPH_CYAN_RED = "anaglyph_cyan_red";
            public static final String ANAGLYPH_GREEN_MAGENTA = "anaglyph_green_magenta";
            public static final String ANAGLYPH_YELLOW_BLUE = "anaglyph_yellow_blue";
            public static final String MONOSCOPIC = "monoscopic";
            public static final Set<String> values = new HashSet<String>(Arrays.asList("off", "split_vertical", "split_horizontal", "row_interleaved", "hardware_based", "anaglyph_cyan_red", "anaglyph_green_magenta", "anaglyph_yellow_blue", "monoscopic"));
        }
    }

    public static class PropertyValue
    extends AbstractModel {
        public static final String API_TYPE = "GUI.Property.Value";
        public static final String CURRENTCONTROL = "currentcontrol";
        public static final String CURRENTWINDOW = "currentwindow";
        public static final String FULLSCREEN = "fullscreen";
        public static final String SKIN = "skin";
        public static final String STEREOSCOPICMODE = "stereoscopicmode";
        public final Currentcontrol currentcontrol;
        public final Currentwindow currentwindow;
        public final Boolean fullscreen;
        public final Skin skin;
        public final StereoscopyMode stereoscopicmode;

        public PropertyValue(Currentcontrol currentcontrol, Currentwindow currentwindow, Boolean bl, Skin skin, StereoscopyMode stereoscopyMode) {
            this.currentcontrol = currentcontrol;
            this.currentwindow = currentwindow;
            this.fullscreen = bl;
            this.skin = skin;
            this.stereoscopicmode = stereoscopyMode;
        }

        public PropertyValue(JsonNode jsonNode) {
            this.currentcontrol = jsonNode.has(CURRENTCONTROL) ? new Currentcontrol(jsonNode.get(CURRENTCONTROL)) : null;
            this.currentwindow = jsonNode.has(CURRENTWINDOW) ? new Currentwindow(jsonNode.get(CURRENTWINDOW)) : null;
            this.fullscreen = PropertyValue.parseBoolean(jsonNode, FULLSCREEN);
            this.skin = jsonNode.has(SKIN) ? new Skin(jsonNode.get(SKIN)) : null;
            this.stereoscopicmode = jsonNode.has(STEREOSCOPICMODE) ? new StereoscopyMode(jsonNode.get(STEREOSCOPICMODE)) : null;
        }

        @Override
        public JsonNode toJsonNode() {
            ObjectNode objectNode = OM.createObjectNode();
            objectNode.put(CURRENTCONTROL, this.currentcontrol == null ? null : this.currentcontrol.toJsonNode());
            objectNode.put(CURRENTWINDOW, this.currentwindow == null ? null : this.currentwindow.toJsonNode());
            objectNode.put(FULLSCREEN, this.fullscreen);
            objectNode.put(SKIN, this.skin == null ? null : this.skin.toJsonNode());
            objectNode.put(STEREOSCOPICMODE, this.stereoscopicmode == null ? null : this.stereoscopicmode.toJsonNode());
            return objectNode;
        }

        static List<PropertyValue> getGUIModelPropertyValueList(JsonNode jsonNode, String string) {
            if (jsonNode.has(string)) {
                ArrayNode arrayNode = (ArrayNode)jsonNode.get(string);
                ArrayList<PropertyValue> arrayList = new ArrayList<PropertyValue>(arrayNode.size());
                for (int i = 0; i < arrayNode.size(); ++i) {
                    arrayList.add(new PropertyValue(arrayNode.get(i)));
                }
                return arrayList;
            }
            return new ArrayList<PropertyValue>(0);
        }

        public static class Currentcontrol
        extends AbstractModel {
            public static final String LABEL = "label";
            public final String label;

            public Currentcontrol(String string) {
                this.label = string;
            }

            public Currentcontrol(JsonNode jsonNode) {
                this.label = jsonNode.get(LABEL).getTextValue();
            }

            @Override
            public JsonNode toJsonNode() {
                ObjectNode objectNode = OM.createObjectNode();
                objectNode.put(LABEL, this.label);
                return objectNode;
            }

            static List<Currentcontrol> getGUIModelCurrentcontrolList(JsonNode jsonNode, String string) {
                if (jsonNode.has(string)) {
                    ArrayNode arrayNode = (ArrayNode)jsonNode.get(string);
                    ArrayList<Currentcontrol> arrayList = new ArrayList<Currentcontrol>(arrayNode.size());
                    for (int i = 0; i < arrayNode.size(); ++i) {
                        arrayList.add(new Currentcontrol(arrayNode.get(i)));
                    }
                    return arrayList;
                }
                return new ArrayList<Currentcontrol>(0);
            }
        }

        public static class Currentwindow
        extends AbstractModel {
            public static final String ID = "id";
            public static final String LABEL = "label";
            public final Integer id;
            public final String label;

            public Currentwindow(Integer n, String string) {
                this.id = n;
                this.label = string;
            }

            public Currentwindow(JsonNode jsonNode) {
                this.id = jsonNode.get(ID).getIntValue();
                this.label = jsonNode.get(LABEL).getTextValue();
            }

            @Override
            public JsonNode toJsonNode() {
                ObjectNode objectNode = OM.createObjectNode();
                objectNode.put(ID, this.id);
                objectNode.put(LABEL, this.label);
                return objectNode;
            }

            static List<Currentwindow> getGUIModelCurrentwindowList(JsonNode jsonNode, String string) {
                if (jsonNode.has(string)) {
                    ArrayNode arrayNode = (ArrayNode)jsonNode.get(string);
                    ArrayList<Currentwindow> arrayList = new ArrayList<Currentwindow>(arrayNode.size());
                    for (int i = 0; i < arrayNode.size(); ++i) {
                        arrayList.add(new Currentwindow(arrayNode.get(i)));
                    }
                    return arrayList;
                }
                return new ArrayList<Currentwindow>(0);
            }
        }

        public static class Skin
        extends AbstractModel {
            public static final String ID = "id";
            public static final String NAME = "name";
            public final String id;
            public final String name;

            public Skin(String string, String string2) {
                this.id = string;
                this.name = string2;
            }

            public Skin(JsonNode jsonNode) {
                this.id = jsonNode.get(ID).getTextValue();
                this.name = Skin.parseString(jsonNode, NAME);
            }

            @Override
            public JsonNode toJsonNode() {
                ObjectNode objectNode = OM.createObjectNode();
                objectNode.put(ID, this.id);
                objectNode.put(NAME, this.name);
                return objectNode;
            }

            static List<Skin> getGUIModelSkinList(JsonNode jsonNode, String string) {
                if (jsonNode.has(string)) {
                    ArrayNode arrayNode = (ArrayNode)jsonNode.get(string);
                    ArrayList<Skin> arrayList = new ArrayList<Skin>(arrayNode.size());
                    for (int i = 0; i < arrayNode.size(); ++i) {
                        arrayList.add(new Skin(arrayNode.get(i)));
                    }
                    return arrayList;
                }
                return new ArrayList<Skin>(0);
            }
        }
    }
}

