/*
 * Decompiled with CFR 0.152.
 */
package org.tinymediamanager.jsonrpc.api.model;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.codehaus.jackson.JsonNode;
import org.codehaus.jackson.node.ArrayNode;
import org.codehaus.jackson.node.BooleanNode;
import org.codehaus.jackson.node.ObjectNode;
import org.codehaus.jackson.node.TextNode;
import org.tinymediamanager.jsonrpc.api.AbstractModel;

public final class GlobalModel {

    public static interface Weekday {
        public static final String MONDAY = "monday";
        public static final String TUESDAY = "tuesday";
        public static final String WEDNESDAY = "wednesday";
        public static final String THURSDAY = "thursday";
        public static final String FRIDAY = "friday";
        public static final String SATURDAY = "saturday";
        public static final String SUNDAY = "sunday";
        public static final Set<String> values = new HashSet<String>(Arrays.asList("monday", "tuesday", "wednesday", "thursday", "friday", "saturday", "sunday"));
    }

    public static interface IncrementDecrement {
        public static final String INCREMENT = "increment";
        public static final String DECREMENT = "decrement";
        public static final Set<String> values = new HashSet<String>(Arrays.asList("increment", "decrement"));
    }

    public static class Toggle
    extends AbstractModel {
        public static final String API_TYPE = "Global.Toggle";
        public final Boolean booleanArg;
        public final String stringArg;

        public Toggle(Boolean bl) {
            this.booleanArg = bl;
            this.stringArg = null;
        }

        public Toggle(String string) {
            this.stringArg = string;
            this.booleanArg = null;
        }

        @Override
        public JsonNode toJsonNode() {
            if (this.booleanArg != null) {
                return this.booleanArg != false ? BooleanNode.TRUE : BooleanNode.FALSE;
            }
            if (this.stringArg != null) {
                return new TextNode(this.stringArg);
            }
            return null;
        }

        public static interface StringArg {
            public static final String TOGGLE = "toggle";
            public static final Set<String> values = new HashSet<String>(Arrays.asList("toggle"));
        }
    }

    public static class Time
    extends AbstractModel {
        public static final String API_TYPE = "Global.Time";
        public static final String HOURS = "hours";
        public static final String MILLISECONDS = "milliseconds";
        public static final String MINUTES = "minutes";
        public static final String SECONDS = "seconds";
        public final Integer hours;
        public final Integer milliseconds;
        public final Integer minutes;
        public final Integer seconds;

        public Time(Integer n, Integer n2, Integer n3, Integer n4) {
            this.hours = n;
            this.milliseconds = n2;
            this.minutes = n3;
            this.seconds = n4;
        }

        public long getMilliseconds() {
            return this.hours * 3600000 + this.minutes * 60000 + this.seconds * 1000 + this.milliseconds;
        }

        public Time(JsonNode jsonNode) {
            this.hours = jsonNode.get(HOURS).getIntValue();
            this.milliseconds = jsonNode.get(MILLISECONDS).getIntValue();
            this.minutes = jsonNode.get(MINUTES).getIntValue();
            this.seconds = jsonNode.get(SECONDS).getIntValue();
        }

        @Override
        public JsonNode toJsonNode() {
            ObjectNode objectNode = OM.createObjectNode();
            objectNode.put(HOURS, this.hours);
            objectNode.put(MILLISECONDS, this.milliseconds);
            objectNode.put(MINUTES, this.minutes);
            objectNode.put(SECONDS, this.seconds);
            return objectNode;
        }

        static List<Time> getGlobalModelTimeList(JsonNode jsonNode, String string) {
            if (jsonNode.has(string)) {
                ArrayNode arrayNode = (ArrayNode)jsonNode.get(string);
                ArrayList<Time> arrayList = new ArrayList<Time>(arrayNode.size());
                for (int i = 0; i < arrayNode.size(); ++i) {
                    arrayList.add(new Time(arrayNode.get(i)));
                }
                return arrayList;
            }
            return new ArrayList<Time>(0);
        }
    }
}

