/*
 * Decompiled with CFR 0.152.
 */
package org.tinymediamanager.jsonrpc.api.model;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.codehaus.jackson.JsonNode;
import org.codehaus.jackson.node.ArrayNode;
import org.codehaus.jackson.node.ObjectNode;
import org.tinymediamanager.jsonrpc.api.AbstractModel;
import org.tinymediamanager.jsonrpc.api.model.GlobalModel;
import org.tinymediamanager.jsonrpc.api.model.NotificationsModel;

public final class PlayerModel {

    public static interface Type {
        public static final String VIDEO = "video";
        public static final String AUDIO = "audio";
        public static final String PICTURE = "picture";
        public static final Set<String> values = new HashSet<String>(Arrays.asList("video", "audio", "picture"));
    }

    public static interface Repeat {
        public static final String OFF = "off";
        public static final String ONE = "one";
        public static final String ALL = "all";
        public static final Set<String> values = new HashSet<String>(Arrays.asList("off", "one", "all"));
    }

    public static interface PropertyName {
        public static final String TYPE = "type";
        public static final String PARTYMODE = "partymode";
        public static final String SPEED = "speed";
        public static final String TIME = "time";
        public static final String PERCENTAGE = "percentage";
        public static final String TOTALTIME = "totaltime";
        public static final String PLAYLISTID = "playlistid";
        public static final String POSITION = "position";
        public static final String REPEAT = "repeat";
        public static final String SHUFFLED = "shuffled";
        public static final String CANSEEK = "canseek";
        public static final String CANCHANGESPEED = "canchangespeed";
        public static final String CANMOVE = "canmove";
        public static final String CANZOOM = "canzoom";
        public static final String CANROTATE = "canrotate";
        public static final String CANSHUFFLE = "canshuffle";
        public static final String CANREPEAT = "canrepeat";
        public static final String CURRENTAUDIOSTREAM = "currentaudiostream";
        public static final String AUDIOSTREAMS = "audiostreams";
        public static final String SUBTITLEENABLED = "subtitleenabled";
        public static final String CURRENTSUBTITLE = "currentsubtitle";
        public static final String SUBTITLES = "subtitles";
        public static final String LIVE = "live";
        public static final Set<String> values = new HashSet<String>(Arrays.asList("type", "partymode", "speed", "time", "percentage", "totaltime", "playlistid", "position", "repeat", "shuffled", "canseek", "canchangespeed", "canmove", "canzoom", "canrotate", "canshuffle", "canrepeat", "currentaudiostream", "audiostreams", "subtitleenabled", "currentsubtitle", "subtitles", "live"));
    }

    public static class Subtitle
    extends AbstractModel {
        public static final String API_TYPE = "Player.Subtitle";
        public static final String INDEX = "index";
        public static final String LANGUAGE = "language";
        public static final String NAME = "name";
        public final Integer index;
        public final String language;
        public final String name;

        public Subtitle(Integer n, String string, String string2) {
            this.index = n;
            this.language = string;
            this.name = string2;
        }

        public Subtitle(JsonNode jsonNode) {
            this.index = jsonNode.get(INDEX).getIntValue();
            this.language = jsonNode.get(LANGUAGE).getTextValue();
            this.name = jsonNode.get(NAME).getTextValue();
        }

        @Override
        public JsonNode toJsonNode() {
            ObjectNode objectNode = OM.createObjectNode();
            objectNode.put(INDEX, this.index);
            objectNode.put(LANGUAGE, this.language);
            objectNode.put(NAME, this.name);
            return objectNode;
        }

        static List<Subtitle> getPlayerModelSubtitleList(JsonNode jsonNode, String string) {
            if (jsonNode.has(string)) {
                ArrayNode arrayNode = (ArrayNode)jsonNode.get(string);
                ArrayList<Subtitle> arrayList = new ArrayList<Subtitle>(arrayNode.size());
                for (int i = 0; i < arrayNode.size(); ++i) {
                    arrayList.add(new Subtitle(arrayNode.get(i)));
                }
                return arrayList;
            }
            return new ArrayList<Subtitle>(0);
        }
    }

    public static class Speed
    extends AbstractModel {
        public static final String API_TYPE = "Player.Speed";
        public static final String SPEED = "speed";
        public final Integer speed;

        public Speed(Integer n) {
            this.speed = n;
        }

        public Speed(JsonNode jsonNode) {
            this.speed = Speed.parseInt(jsonNode, SPEED);
        }

        @Override
        public JsonNode toJsonNode() {
            ObjectNode objectNode = OM.createObjectNode();
            objectNode.put(SPEED, this.speed);
            return objectNode;
        }

        static List<Speed> getPlayerModelSpeedList(JsonNode jsonNode, String string) {
            if (jsonNode.has(string)) {
                ArrayNode arrayNode = (ArrayNode)jsonNode.get(string);
                ArrayList<Speed> arrayList = new ArrayList<Speed>(arrayNode.size());
                for (int i = 0; i < arrayNode.size(); ++i) {
                    arrayList.add(new Speed(arrayNode.get(i)));
                }
                return arrayList;
            }
            return new ArrayList<Speed>(0);
        }
    }

    public static class PropertyValue
    extends AbstractModel {
        public static final String API_TYPE = "Player.Property.Value";
        public static final String AUDIOSTREAMS = "audiostreams";
        public static final String CANCHANGESPEED = "canchangespeed";
        public static final String CANMOVE = "canmove";
        public static final String CANREPEAT = "canrepeat";
        public static final String CANROTATE = "canrotate";
        public static final String CANSEEK = "canseek";
        public static final String CANSHUFFLE = "canshuffle";
        public static final String CANZOOM = "canzoom";
        public static final String CURRENTAUDIOSTREAM = "currentaudiostream";
        public static final String CURRENTSUBTITLE = "currentsubtitle";
        public static final String LIVE = "live";
        public static final String PARTYMODE = "partymode";
        public static final String PERCENTAGE = "percentage";
        public static final String PLAYLISTID = "playlistid";
        public static final String POSITION = "position";
        public static final String REPEAT = "repeat";
        public static final String SHUFFLED = "shuffled";
        public static final String SPEED = "speed";
        public static final String SUBTITLEENABLED = "subtitleenabled";
        public static final String SUBTITLES = "subtitles";
        public static final String TIME = "time";
        public static final String TOTALTIME = "totaltime";
        public static final String TYPE = "type";
        public final List<AudioStream> audiostreams;
        public final Boolean canchangespeed;
        public final Boolean canmove;
        public final Boolean canrepeat;
        public final Boolean canrotate;
        public final Boolean canseek;
        public final Boolean canshuffle;
        public final Boolean canzoom;
        public final AudioStream currentaudiostream;
        public final Subtitle currentsubtitle;
        public final Boolean live;
        public final Boolean partymode;
        public final Double percentage;
        public final Integer playlistid;
        public final Integer position;
        public final String repeat;
        public final Boolean shuffled;
        public final Integer speed;
        public final Boolean subtitleenabled;
        public final List<Subtitle> subtitles;
        public final GlobalModel.Time time;
        public final GlobalModel.Time totaltime;
        public final String type;

        public PropertyValue(List<AudioStream> list, Boolean bl, Boolean bl2, Boolean bl3, Boolean bl4, Boolean bl5, Boolean bl6, Boolean bl7, AudioStream audioStream, Subtitle subtitle, Boolean bl8, Boolean bl9, Double d, Integer n, Integer n2, String string, Boolean bl10, Integer n3, Boolean bl11, List<Subtitle> list2, GlobalModel.Time time, GlobalModel.Time time2, String string2) {
            this.audiostreams = list;
            this.canchangespeed = bl;
            this.canmove = bl2;
            this.canrepeat = bl3;
            this.canrotate = bl4;
            this.canseek = bl5;
            this.canshuffle = bl6;
            this.canzoom = bl7;
            this.currentaudiostream = audioStream;
            this.currentsubtitle = subtitle;
            this.live = bl8;
            this.partymode = bl9;
            this.percentage = d;
            this.playlistid = n;
            this.position = n2;
            this.repeat = string;
            this.shuffled = bl10;
            this.speed = n3;
            this.subtitleenabled = bl11;
            this.subtitles = list2;
            this.time = time;
            this.totaltime = time2;
            this.type = string2;
        }

        public PropertyValue(JsonNode jsonNode) {
            this.audiostreams = AudioStream.getPlayerModelAudioStreamList(jsonNode, AUDIOSTREAMS);
            this.canchangespeed = PropertyValue.parseBoolean(jsonNode, CANCHANGESPEED);
            this.canmove = PropertyValue.parseBoolean(jsonNode, CANMOVE);
            this.canrepeat = PropertyValue.parseBoolean(jsonNode, CANREPEAT);
            this.canrotate = PropertyValue.parseBoolean(jsonNode, CANROTATE);
            this.canseek = PropertyValue.parseBoolean(jsonNode, CANSEEK);
            this.canshuffle = PropertyValue.parseBoolean(jsonNode, CANSHUFFLE);
            this.canzoom = PropertyValue.parseBoolean(jsonNode, CANZOOM);
            this.currentaudiostream = jsonNode.has(CURRENTAUDIOSTREAM) ? new AudioStream(jsonNode.get(CURRENTAUDIOSTREAM)) : null;
            this.currentsubtitle = jsonNode.has(CURRENTSUBTITLE) ? new Subtitle(jsonNode.get(CURRENTSUBTITLE)) : null;
            this.live = PropertyValue.parseBoolean(jsonNode, LIVE);
            this.partymode = PropertyValue.parseBoolean(jsonNode, PARTYMODE);
            this.percentage = PropertyValue.parseDouble(jsonNode, PERCENTAGE);
            this.playlistid = PropertyValue.parseInt(jsonNode, PLAYLISTID);
            this.position = PropertyValue.parseInt(jsonNode, POSITION);
            this.repeat = PropertyValue.parseString(jsonNode, REPEAT);
            this.shuffled = PropertyValue.parseBoolean(jsonNode, SHUFFLED);
            this.speed = PropertyValue.parseInt(jsonNode, SPEED);
            this.subtitleenabled = PropertyValue.parseBoolean(jsonNode, SUBTITLEENABLED);
            this.subtitles = Subtitle.getPlayerModelSubtitleList(jsonNode, SUBTITLES);
            this.time = jsonNode.has(TIME) ? new GlobalModel.Time(jsonNode.get(TIME)) : null;
            this.totaltime = jsonNode.has(TOTALTIME) ? new GlobalModel.Time(jsonNode.get(TOTALTIME)) : null;
            this.type = PropertyValue.parseString(jsonNode, TYPE);
        }

        @Override
        public JsonNode toJsonNode() {
            ObjectNode objectNode = OM.createObjectNode();
            ArrayNode arrayNode = OM.createArrayNode();
            for (AudioStream object : this.audiostreams) {
                arrayNode.add(object.toJsonNode());
            }
            objectNode.put(AUDIOSTREAMS, (JsonNode)arrayNode);
            objectNode.put(CANCHANGESPEED, this.canchangespeed);
            objectNode.put(CANMOVE, this.canmove);
            objectNode.put(CANREPEAT, this.canrepeat);
            objectNode.put(CANROTATE, this.canrotate);
            objectNode.put(CANSEEK, this.canseek);
            objectNode.put(CANSHUFFLE, this.canshuffle);
            objectNode.put(CANZOOM, this.canzoom);
            objectNode.put(CURRENTAUDIOSTREAM, this.currentaudiostream == null ? null : this.currentaudiostream.toJsonNode());
            objectNode.put(CURRENTSUBTITLE, this.currentsubtitle == null ? null : this.currentsubtitle.toJsonNode());
            objectNode.put(LIVE, this.live);
            objectNode.put(PARTYMODE, this.partymode);
            objectNode.put(PERCENTAGE, this.percentage);
            objectNode.put(PLAYLISTID, this.playlistid);
            objectNode.put(POSITION, this.position);
            objectNode.put(REPEAT, this.repeat);
            objectNode.put(SHUFFLED, this.shuffled);
            objectNode.put(SPEED, this.speed);
            objectNode.put(SUBTITLEENABLED, this.subtitleenabled);
            ArrayNode arrayNode2 = OM.createArrayNode();
            for (Subtitle subtitle : this.subtitles) {
                arrayNode2.add(subtitle.toJsonNode());
            }
            objectNode.put(SUBTITLES, (JsonNode)arrayNode2);
            objectNode.put(TIME, this.time == null ? null : this.time.toJsonNode());
            objectNode.put(TOTALTIME, this.totaltime == null ? null : this.totaltime.toJsonNode());
            objectNode.put(TYPE, this.type);
            return objectNode;
        }

        static List<PropertyValue> getPlayerModelPropertyValueList(JsonNode jsonNode, String string) {
            if (jsonNode.has(string)) {
                ArrayNode arrayNode = (ArrayNode)jsonNode.get(string);
                ArrayList<PropertyValue> arrayList = new ArrayList<PropertyValue>(arrayNode.size());
                for (int i = 0; i < arrayNode.size(); ++i) {
                    arrayList.add(new PropertyValue(arrayNode.get(i)));
                }
                return arrayList;
            }
            return new ArrayList<PropertyValue>(0);
        }

        public static interface Type {
            public static final String VIDEO = "video";
            public static final String AUDIO = "audio";
            public static final String PICTURE = "picture";
            public static final Set<String> values = new HashSet<String>(Arrays.asList("video", "audio", "picture"));
        }

        public static interface Repeat {
            public static final String OFF = "off";
            public static final String ONE = "one";
            public static final String ALL = "all";
            public static final Set<String> values = new HashSet<String>(Arrays.asList("off", "one", "all"));
        }
    }

    public static class PositionTime
    extends AbstractModel {
        public static final String API_TYPE = "Player.Position.Time";
        public static final String HOURS = "hours";
        public static final String MILLISECONDS = "milliseconds";
        public static final String MINUTES = "minutes";
        public static final String SECONDS = "seconds";
        public final Integer hours;
        public final Integer milliseconds;
        public final Integer minutes;
        public final Integer seconds;

        public PositionTime(Integer n, Integer n2, Integer n3, Integer n4) {
            this.hours = n;
            this.milliseconds = n2;
            this.minutes = n3;
            this.seconds = n4;
        }

        @Override
        public JsonNode toJsonNode() {
            ObjectNode objectNode = OM.createObjectNode();
            objectNode.put(HOURS, this.hours);
            objectNode.put(MILLISECONDS, this.milliseconds);
            objectNode.put(MINUTES, this.minutes);
            objectNode.put(SECONDS, this.seconds);
            return objectNode;
        }
    }

    public static class NotificationsPlayerSeek
    extends NotificationsPlayer {
        public static final String API_TYPE = "Player.Notifications.Player.Seek";
        public static final String SEEKOFFSET = "seekoffset";
        public static final String TIME = "time";
        public final GlobalModel.Time seekoffset = null;
        public final GlobalModel.Time time = null;

        @Override
        public JsonNode toJsonNode() {
            ObjectNode objectNode = (ObjectNode)super.toJsonNode();
            objectNode.put(SEEKOFFSET, this.seekoffset == null ? null : this.seekoffset.toJsonNode());
            objectNode.put(TIME, this.time == null ? null : this.time.toJsonNode());
            return objectNode;
        }

        public NotificationsPlayerSeek() {
            super(null, null);
        }
    }

    public static class NotificationsPlayer
    extends AbstractModel {
        public static final String API_TYPE = "Player.Notifications.Player";
        public static final String PLAYERID = "playerid";
        public static final String SPEED = "speed";
        public final Integer playerid;
        public final Integer speed;

        public NotificationsPlayer(Integer n, Integer n2) {
            this.playerid = n;
            this.speed = n2;
        }

        @Override
        public JsonNode toJsonNode() {
            ObjectNode objectNode = OM.createObjectNode();
            objectNode.put(PLAYERID, this.playerid);
            objectNode.put(SPEED, this.speed);
            return objectNode;
        }
    }

    public static class NotificationsData
    extends AbstractModel {
        public static final String API_TYPE = "Player.Notifications.Data";
        public static final String ITEM = "item";
        public static final String PLAYER = "player";
        public final NotificationsModel.Item item;
        public final NotificationsPlayer player;

        public NotificationsData(NotificationsModel.Item item, NotificationsPlayer notificationsPlayer) {
            this.item = item;
            this.player = notificationsPlayer;
        }

        @Override
        public JsonNode toJsonNode() {
            ObjectNode objectNode = OM.createObjectNode();
            objectNode.put(ITEM, this.item == null ? null : this.item.toJsonNode());
            objectNode.put(PLAYER, this.player == null ? null : this.player.toJsonNode());
            return objectNode;
        }
    }

    public static class AudioStream
    extends AbstractModel {
        public static final String API_TYPE = "Player.Audio.Stream";
        public static final String BITRATE = "bitrate";
        public static final String CHANNELS = "channels";
        public static final String CODEC = "codec";
        public static final String INDEX = "index";
        public static final String LANGUAGE = "language";
        public static final String NAME = "name";
        public final Integer bitrate;
        public final Integer channels;
        public final String codec;
        public final Integer index;
        public final String language;
        public final String name;

        public AudioStream(Integer n, Integer n2, String string, Integer n3, String string2, String string3) {
            this.bitrate = n;
            this.channels = n2;
            this.codec = string;
            this.index = n3;
            this.language = string2;
            this.name = string3;
        }

        public AudioStream(JsonNode jsonNode) {
            this.bitrate = jsonNode.get(BITRATE).getIntValue();
            this.channels = jsonNode.get(CHANNELS).getIntValue();
            this.codec = jsonNode.get(CODEC).getTextValue();
            this.index = jsonNode.get(INDEX).getIntValue();
            this.language = jsonNode.get(LANGUAGE).getTextValue();
            this.name = jsonNode.get(NAME).getTextValue();
        }

        @Override
        public JsonNode toJsonNode() {
            ObjectNode objectNode = OM.createObjectNode();
            objectNode.put(BITRATE, this.bitrate);
            objectNode.put(CHANNELS, this.channels);
            objectNode.put(CODEC, this.codec);
            objectNode.put(INDEX, this.index);
            objectNode.put(LANGUAGE, this.language);
            objectNode.put(NAME, this.name);
            return objectNode;
        }

        static List<AudioStream> getPlayerModelAudioStreamList(JsonNode jsonNode, String string) {
            if (jsonNode.has(string)) {
                ArrayNode arrayNode = (ArrayNode)jsonNode.get(string);
                ArrayList<AudioStream> arrayList = new ArrayList<AudioStream>(arrayNode.size());
                for (int i = 0; i < arrayNode.size(); ++i) {
                    arrayList.add(new AudioStream(arrayNode.get(i)));
                }
                return arrayList;
            }
            return new ArrayList<AudioStream>(0);
        }
    }
}

