/*
 * Decompiled with CFR 0.152.
 */
package org.tinymediamanager.jsonrpc.api.model;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.codehaus.jackson.JsonNode;
import org.codehaus.jackson.node.ArrayNode;
import org.codehaus.jackson.node.ObjectNode;
import org.tinymediamanager.jsonrpc.api.AbstractModel;

public final class PlaylistModel {

    public static interface Type {
        public static final String UNKNOWN = "unknown";
        public static final String VIDEO = "video";
        public static final String AUDIO = "audio";
        public static final String PICTURE = "picture";
        public static final String MIXED = "mixed";
        public static final Set<String> values = new HashSet<String>(Arrays.asList("unknown", "video", "audio", "picture", "mixed"));
    }

    public static interface PropertyName {
        public static final String TYPE = "type";
        public static final String SIZE = "size";
        public static final Set<String> values = new HashSet<String>(Arrays.asList("type", "size"));
    }

    public static class PropertyValue
    extends AbstractModel {
        public static final String API_TYPE = "Playlist.Property.Value";
        public static final String SIZE = "size";
        public static final String TYPE = "type";
        public final Integer size;
        public final String type;

        public PropertyValue(Integer n, String string) {
            this.size = n;
            this.type = string;
        }

        public PropertyValue(JsonNode jsonNode) {
            this.size = PropertyValue.parseInt(jsonNode, SIZE);
            this.type = PropertyValue.parseString(jsonNode, TYPE);
        }

        @Override
        public JsonNode toJsonNode() {
            ObjectNode objectNode = OM.createObjectNode();
            objectNode.put(SIZE, this.size);
            objectNode.put(TYPE, this.type);
            return objectNode;
        }

        static List<PropertyValue> getPlaylistModelPropertyValueList(JsonNode jsonNode, String string) {
            if (jsonNode.has(string)) {
                ArrayNode arrayNode = (ArrayNode)jsonNode.get(string);
                ArrayList<PropertyValue> arrayList = new ArrayList<PropertyValue>(arrayNode.size());
                for (int i = 0; i < arrayNode.size(); ++i) {
                    arrayList.add(new PropertyValue(arrayNode.get(i)));
                }
                return arrayList;
            }
            return new ArrayList<PropertyValue>(0);
        }

        public static interface Type {
            public static final String UNKNOWN = "unknown";
            public static final String VIDEO = "video";
            public static final String AUDIO = "audio";
            public static final String PICTURE = "picture";
            public static final String MIXED = "mixed";
            public static final Set<String> values = new HashSet<String>(Arrays.asList("unknown", "video", "audio", "picture", "mixed"));
        }
    }

    public static class Item
    extends AbstractModel {
        public static final String API_TYPE = "Playlist.Item";
        public final Albumid albumid;
        public final Artistid artistid;
        public final Episodeid episodeid;
        public final File file;
        public final Genreid genreid;
        public final Movieid movieid;
        public final Musicvideoid musicvideoid;
        public final RecursiveDirectoryMedia recursiveDirectoryMedia;
        public final Songid songid;

        public Item(Albumid albumid) {
            this.albumid = albumid;
            this.artistid = null;
            this.episodeid = null;
            this.file = null;
            this.genreid = null;
            this.movieid = null;
            this.musicvideoid = null;
            this.recursiveDirectoryMedia = null;
            this.songid = null;
        }

        public Item(Artistid artistid) {
            this.artistid = artistid;
            this.albumid = null;
            this.episodeid = null;
            this.file = null;
            this.genreid = null;
            this.movieid = null;
            this.musicvideoid = null;
            this.recursiveDirectoryMedia = null;
            this.songid = null;
        }

        public Item(Episodeid episodeid) {
            this.episodeid = episodeid;
            this.albumid = null;
            this.artistid = null;
            this.file = null;
            this.genreid = null;
            this.movieid = null;
            this.musicvideoid = null;
            this.recursiveDirectoryMedia = null;
            this.songid = null;
        }

        public Item(File file) {
            this.file = file;
            this.albumid = null;
            this.artistid = null;
            this.episodeid = null;
            this.genreid = null;
            this.movieid = null;
            this.musicvideoid = null;
            this.recursiveDirectoryMedia = null;
            this.songid = null;
        }

        public Item(Genreid genreid) {
            this.genreid = genreid;
            this.albumid = null;
            this.artistid = null;
            this.episodeid = null;
            this.file = null;
            this.movieid = null;
            this.musicvideoid = null;
            this.recursiveDirectoryMedia = null;
            this.songid = null;
        }

        public Item(Movieid movieid) {
            this.movieid = movieid;
            this.albumid = null;
            this.artistid = null;
            this.episodeid = null;
            this.file = null;
            this.genreid = null;
            this.musicvideoid = null;
            this.recursiveDirectoryMedia = null;
            this.songid = null;
        }

        public Item(Musicvideoid musicvideoid) {
            this.musicvideoid = musicvideoid;
            this.albumid = null;
            this.artistid = null;
            this.episodeid = null;
            this.file = null;
            this.genreid = null;
            this.movieid = null;
            this.recursiveDirectoryMedia = null;
            this.songid = null;
        }

        public Item(RecursiveDirectoryMedia recursiveDirectoryMedia) {
            this.recursiveDirectoryMedia = recursiveDirectoryMedia;
            this.albumid = null;
            this.artistid = null;
            this.episodeid = null;
            this.file = null;
            this.genreid = null;
            this.movieid = null;
            this.musicvideoid = null;
            this.songid = null;
        }

        public Item(Songid songid) {
            this.songid = songid;
            this.albumid = null;
            this.artistid = null;
            this.episodeid = null;
            this.file = null;
            this.genreid = null;
            this.movieid = null;
            this.musicvideoid = null;
            this.recursiveDirectoryMedia = null;
        }

        @Override
        public JsonNode toJsonNode() {
            if (this.albumid != null) {
                return this.albumid.toJsonNode();
            }
            if (this.artistid != null) {
                return this.artistid.toJsonNode();
            }
            if (this.episodeid != null) {
                return this.episodeid.toJsonNode();
            }
            if (this.file != null) {
                return this.file.toJsonNode();
            }
            if (this.genreid != null) {
                return this.genreid.toJsonNode();
            }
            if (this.movieid != null) {
                return this.movieid.toJsonNode();
            }
            if (this.musicvideoid != null) {
                return this.musicvideoid.toJsonNode();
            }
            if (this.recursiveDirectoryMedia != null) {
                return this.recursiveDirectoryMedia.toJsonNode();
            }
            if (this.songid != null) {
                return this.songid.toJsonNode();
            }
            return null;
        }

        public static class Genreid
        extends AbstractModel {
            public static final String GENREID = "genreid";
            public final Integer genreid;

            public Genreid(Integer n) {
                this.genreid = n;
            }

            @Override
            public JsonNode toJsonNode() {
                ObjectNode objectNode = OM.createObjectNode();
                objectNode.put(GENREID, this.genreid);
                return objectNode;
            }
        }

        public static class Songid
        extends AbstractModel {
            public static final String SONGID = "songid";
            public final Integer songid;

            public Songid(Integer n) {
                this.songid = n;
            }

            @Override
            public JsonNode toJsonNode() {
                ObjectNode objectNode = OM.createObjectNode();
                objectNode.put(SONGID, this.songid);
                return objectNode;
            }
        }

        public static class Albumid
        extends AbstractModel {
            public static final String ALBUMID = "albumid";
            public final Integer albumid;

            public Albumid(Integer n) {
                this.albumid = n;
            }

            @Override
            public JsonNode toJsonNode() {
                ObjectNode objectNode = OM.createObjectNode();
                objectNode.put(ALBUMID, this.albumid);
                return objectNode;
            }
        }

        public static class Artistid
        extends AbstractModel {
            public static final String ARTISTID = "artistid";
            public final Integer artistid;

            public Artistid(Integer n) {
                this.artistid = n;
            }

            @Override
            public JsonNode toJsonNode() {
                ObjectNode objectNode = OM.createObjectNode();
                objectNode.put(ARTISTID, this.artistid);
                return objectNode;
            }
        }

        public static class Musicvideoid
        extends AbstractModel {
            public static final String MUSICVIDEOID = "musicvideoid";
            public final Integer musicvideoid;

            public Musicvideoid(Integer n) {
                this.musicvideoid = n;
            }

            @Override
            public JsonNode toJsonNode() {
                ObjectNode objectNode = OM.createObjectNode();
                objectNode.put(MUSICVIDEOID, this.musicvideoid);
                return objectNode;
            }
        }

        public static class Episodeid
        extends AbstractModel {
            public static final String EPISODEID = "episodeid";
            public final Integer episodeid;

            public Episodeid(Integer n) {
                this.episodeid = n;
            }

            @Override
            public JsonNode toJsonNode() {
                ObjectNode objectNode = OM.createObjectNode();
                objectNode.put(EPISODEID, this.episodeid);
                return objectNode;
            }
        }

        public static class Movieid
        extends AbstractModel {
            public static final String MOVIEID = "movieid";
            public final Integer movieid;

            public Movieid(Integer n) {
                this.movieid = n;
            }

            @Override
            public JsonNode toJsonNode() {
                ObjectNode objectNode = OM.createObjectNode();
                objectNode.put(MOVIEID, this.movieid);
                return objectNode;
            }
        }

        public static class RecursiveDirectoryMedia
        extends AbstractModel {
            public static final String DIRECTORY = "directory";
            public static final String MEDIA = "media";
            public static final String RECURSIVE = "recursive";
            public final String directory;
            public final String media;
            public final Boolean recursive;

            public RecursiveDirectoryMedia(String string, String string2, Boolean bl) {
                this.directory = string;
                this.media = string2;
                this.recursive = bl;
            }

            @Override
            public JsonNode toJsonNode() {
                ObjectNode objectNode = OM.createObjectNode();
                objectNode.put(DIRECTORY, this.directory);
                objectNode.put(MEDIA, this.media);
                objectNode.put(RECURSIVE, this.recursive);
                return objectNode;
            }

            public static interface Media {
                public static final String VIDEO = "video";
                public static final String MUSIC = "music";
                public static final String PICTURES = "pictures";
                public static final String FILES = "files";
                public static final String PROGRAMS = "programs";
                public static final Set<String> values = new HashSet<String>(Arrays.asList("video", "music", "pictures", "files", "programs"));
            }
        }

        public static class File
        extends AbstractModel {
            public static final String FILE = "file";
            public final String file;

            public File(String string) {
                this.file = string;
            }

            @Override
            public JsonNode toJsonNode() {
                ObjectNode objectNode = OM.createObjectNode();
                objectNode.put(FILE, this.file);
                return objectNode;
            }
        }
    }
}

