/*
 * Decompiled with CFR 0.152.
 */
package org.tinymediamanager.jsonrpc.api.model;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.codehaus.jackson.JsonNode;
import org.codehaus.jackson.node.ArrayNode;
import org.codehaus.jackson.node.ObjectNode;
import org.tinymediamanager.jsonrpc.api.AbstractModel;
import org.tinymediamanager.jsonrpc.api.model.ItemModel;

public final class ProfilesModel {

    public static interface ProfileFields {
        public static final String THUMBNAIL = "thumbnail";
        public static final String LOCKMODE = "lockmode";
        public static final Set<String> values = new HashSet<String>(Arrays.asList("thumbnail", "lockmode"));
    }

    public static class Password
    extends AbstractModel {
        public static final String API_TYPE = "Profiles.Password";
        public static final String ENCRYPTION = "encryption";
        public static final String VALUE = "value";
        public final String encryption;
        public final String value;

        public Password(String string, String string2) {
            this.encryption = string;
            this.value = string2;
        }

        @Override
        public JsonNode toJsonNode() {
            ObjectNode objectNode = OM.createObjectNode();
            objectNode.put(ENCRYPTION, this.encryption);
            objectNode.put(VALUE, this.value);
            return objectNode;
        }

        public static interface Encryption {
            public static final String NONE = "none";
            public static final String MD5 = "md5";
            public static final Set<String> values = new HashSet<String>(Arrays.asList("none", "md5"));
        }
    }

    public static class ProfileDetail
    extends ItemModel.BaseDetail {
        public static final String API_TYPE = "Profiles.Details.Profile";
        public static final String LOCKMODE = "lockmode";
        public static final String THUMBNAIL = "thumbnail";
        public final Integer lockmode;
        public final String thumbnail;

        public ProfileDetail(JsonNode jsonNode) {
            super(jsonNode);
            this.lockmode = ProfileDetail.parseInt(jsonNode, LOCKMODE);
            this.thumbnail = ProfileDetail.parseString(jsonNode, THUMBNAIL);
        }

        @Override
        public JsonNode toJsonNode() {
            ObjectNode objectNode = (ObjectNode)super.toJsonNode();
            objectNode.put(LOCKMODE, this.lockmode);
            objectNode.put(THUMBNAIL, this.thumbnail);
            return objectNode;
        }

        static List<ProfileDetail> getProfilesModelProfileDetailList(JsonNode jsonNode, String string) {
            if (jsonNode.has(string)) {
                ArrayNode arrayNode = (ArrayNode)jsonNode.get(string);
                ArrayList<ProfileDetail> arrayList = new ArrayList<ProfileDetail>(arrayNode.size());
                for (int i = 0; i < arrayNode.size(); ++i) {
                    arrayList.add(new ProfileDetail(arrayNode.get(i)));
                }
                return arrayList;
            }
            return new ArrayList<ProfileDetail>(0);
        }
    }
}

