/*
 * Decompiled with CFR 0.152.
 */
package org.tinymediamanager.jsonrpc.api.model;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.codehaus.jackson.JsonNode;
import org.codehaus.jackson.node.ArrayNode;
import org.codehaus.jackson.node.ObjectNode;
import org.tinymediamanager.jsonrpc.api.AbstractModel;
import org.tinymediamanager.jsonrpc.api.model.ListModel;
import org.tinymediamanager.jsonrpc.api.model.MediaModel;

public final class VideoModel {

    public static interface TVShowFields {
        public static final String TITLE = "title";
        public static final String GENRE = "genre";
        public static final String YEAR = "year";
        public static final String RATING = "rating";
        public static final String PLOT = "plot";
        public static final String STUDIO = "studio";
        public static final String MPAA = "mpaa";
        public static final String CAST = "cast";
        public static final String PLAYCOUNT = "playcount";
        public static final String EPISODE = "episode";
        public static final String IMDBNUMBER = "imdbnumber";
        public static final String PREMIERED = "premiered";
        public static final String VOTES = "votes";
        public static final String LASTPLAYED = "lastplayed";
        public static final String FANART = "fanart";
        public static final String THUMBNAIL = "thumbnail";
        public static final String FILE = "file";
        public static final String ORIGINALTITLE = "originaltitle";
        public static final String SORTTITLE = "sorttitle";
        public static final String EPISODEGUIDE = "episodeguide";
        public static final String SEASON = "season";
        public static final String WATCHEDEPISODES = "watchedepisodes";
        public static final String DATEADDED = "dateadded";
        public static final String TAG = "tag";
        public static final String ART = "art";
        public static final String USERRATING = "userrating";
        public static final Set<String> values = new HashSet<String>(Arrays.asList("title", "genre", "year", "rating", "plot", "studio", "mpaa", "cast", "playcount", "episode", "imdbnumber", "premiered", "votes", "lastplayed", "fanart", "thumbnail", "file", "originaltitle", "sorttitle", "episodeguide", "season", "watchedepisodes", "dateadded", "tag", "art", "userrating"));
    }

    public static interface SeasonFields {
        public static final String SEASON = "season";
        public static final String SHOWTITLE = "showtitle";
        public static final String PLAYCOUNT = "playcount";
        public static final String EPISODE = "episode";
        public static final String FANART = "fanart";
        public static final String THUMBNAIL = "thumbnail";
        public static final String TVSHOWID = "tvshowid";
        public static final String WATCHEDEPISODES = "watchedepisodes";
        public static final String ART = "art";
        public static final Set<String> values = new HashSet<String>(Arrays.asList("season", "showtitle", "playcount", "episode", "fanart", "thumbnail", "tvshowid", "watchedepisodes", "art"));
    }

    public static interface MusicVideoFields {
        public static final String TITLE = "title";
        public static final String PLAYCOUNT = "playcount";
        public static final String RUNTIME = "runtime";
        public static final String DIRECTOR = "director";
        public static final String STUDIO = "studio";
        public static final String YEAR = "year";
        public static final String PLOT = "plot";
        public static final String ALBUM = "album";
        public static final String ARTIST = "artist";
        public static final String GENRE = "genre";
        public static final String TRACK = "track";
        public static final String STREAMDETAILS = "streamdetails";
        public static final String LASTPLAYED = "lastplayed";
        public static final String FANART = "fanart";
        public static final String THUMBNAIL = "thumbnail";
        public static final String FILE = "file";
        public static final String RESUME = "resume";
        public static final String DATEADDED = "dateadded";
        public static final String TAG = "tag";
        public static final String ART = "art";
        public static final String USERRATING = "userrating";
        public static final Set<String> values = new HashSet<String>(Arrays.asList("title", "playcount", "runtime", "director", "studio", "year", "plot", "album", "artist", "genre", "track", "streamdetails", "lastplayed", "fanart", "thumbnail", "file", "resume", "dateadded", "tag", "art", "userrating"));
    }

    public static interface MovieSetFields {
        public static final String TITLE = "title";
        public static final String PLAYCOUNT = "playcount";
        public static final String FANART = "fanart";
        public static final String THUMBNAIL = "thumbnail";
        public static final String ART = "art";
        public static final String PLOT = "plot";
        public static final Set<String> values = new HashSet<String>(Arrays.asList("title", "playcount", "fanart", "thumbnail", "art", "plot"));
    }

    public static interface MovieFields {
        public static final String TITLE = "title";
        public static final String GENRE = "genre";
        public static final String YEAR = "year";
        public static final String RATING = "rating";
        public static final String DIRECTOR = "director";
        public static final String TRAILER = "trailer";
        public static final String TAGLINE = "tagline";
        public static final String PLOT = "plot";
        public static final String PLOTOUTLINE = "plotoutline";
        public static final String ORIGINALTITLE = "originaltitle";
        public static final String LASTPLAYED = "lastplayed";
        public static final String PLAYCOUNT = "playcount";
        public static final String WRITER = "writer";
        public static final String STUDIO = "studio";
        public static final String MPAA = "mpaa";
        public static final String CAST = "cast";
        public static final String COUNTRY = "country";
        public static final String IMDBNUMBER = "imdbnumber";
        public static final String RUNTIME = "runtime";
        public static final String SET = "set";
        public static final String SHOWLINK = "showlink";
        public static final String STREAMDETAILS = "streamdetails";
        public static final String TOP250 = "top250";
        public static final String VOTES = "votes";
        public static final String FANART = "fanart";
        public static final String THUMBNAIL = "thumbnail";
        public static final String FILE = "file";
        public static final String SORTTITLE = "sorttitle";
        public static final String RESUME = "resume";
        public static final String SETID = "setid";
        public static final String DATEADDED = "dateadded";
        public static final String TAG = "tag";
        public static final String ART = "art";
        public static final String USERRATING = "userrating";
        public static final Set<String> values = new HashSet<String>(Arrays.asList("title", "genre", "year", "rating", "director", "trailer", "tagline", "plot", "plotoutline", "originaltitle", "lastplayed", "playcount", "writer", "studio", "mpaa", "cast", "country", "imdbnumber", "runtime", "set", "showlink", "streamdetails", "top250", "votes", "fanart", "thumbnail", "file", "sorttitle", "resume", "setid", "dateadded", "tag", "art", "userrating"));
    }

    public static interface EpisodeFields {
        public static final String TITLE = "title";
        public static final String PLOT = "plot";
        public static final String VOTES = "votes";
        public static final String RATING = "rating";
        public static final String WRITER = "writer";
        public static final String FIRSTAIRED = "firstaired";
        public static final String PLAYCOUNT = "playcount";
        public static final String RUNTIME = "runtime";
        public static final String DIRECTOR = "director";
        public static final String PRODUCTIONCODE = "productioncode";
        public static final String SEASON = "season";
        public static final String EPISODE = "episode";
        public static final String ORIGINALTITLE = "originaltitle";
        public static final String SHOWTITLE = "showtitle";
        public static final String CAST = "cast";
        public static final String STREAMDETAILS = "streamdetails";
        public static final String LASTPLAYED = "lastplayed";
        public static final String FANART = "fanart";
        public static final String THUMBNAIL = "thumbnail";
        public static final String FILE = "file";
        public static final String RESUME = "resume";
        public static final String TVSHOWID = "tvshowid";
        public static final String DATEADDED = "dateadded";
        public static final String UNIQUEID = "uniqueid";
        public static final String ART = "art";
        public static final String SPECIALSORTSEASON = "specialsortseason";
        public static final String SPECIALSORTEPISODE = "specialsortepisode";
        public static final String USERRATING = "userrating";
        public static final String SEASONID = "seasonid";
        public static final Set<String> values = new HashSet<String>(Arrays.asList("title", "plot", "votes", "rating", "writer", "firstaired", "playcount", "runtime", "director", "productioncode", "season", "episode", "originaltitle", "showtitle", "cast", "streamdetails", "lastplayed", "fanart", "thumbnail", "file", "resume", "tvshowid", "dateadded", "uniqueid", "art", "specialsortseason", "specialsortepisode", "userrating", "seasonid"));
    }

    public static class Streams
    extends AbstractModel {
        public static final String API_TYPE = "Video.Streams";
        public static final String AUDIO = "audio";
        public static final String SUBTITLE = "subtitle";
        public static final String VIDEO = "video";
        public final List<Audio> audio;
        public final List<Subtitle> subtitle;
        public final List<Video> video;

        public Streams(List<Audio> list, List<Subtitle> list2, List<Video> list3) {
            this.audio = list;
            this.subtitle = list2;
            this.video = list3;
        }

        public Streams(JsonNode jsonNode) {
            this.audio = Audio.getVideoModelAudioList(jsonNode, AUDIO);
            this.subtitle = Subtitle.getVideoModelSubtitleList(jsonNode, SUBTITLE);
            this.video = Video.getVideoModelVideoList(jsonNode, VIDEO);
        }

        @Override
        public JsonNode toJsonNode() {
            ObjectNode objectNode = OM.createObjectNode();
            ArrayNode arrayNode = OM.createArrayNode();
            for (Audio object2 : this.audio) {
                arrayNode.add(object2.toJsonNode());
            }
            objectNode.put(AUDIO, (JsonNode)arrayNode);
            ArrayNode arrayNode2 = OM.createArrayNode();
            for (Subtitle subtitle : this.subtitle) {
                arrayNode2.add(subtitle.toJsonNode());
            }
            objectNode.put(SUBTITLE, (JsonNode)arrayNode2);
            ArrayNode arrayNode3 = OM.createArrayNode();
            for (Video video : this.video) {
                arrayNode3.add(video.toJsonNode());
            }
            objectNode.put(VIDEO, (JsonNode)arrayNode3);
            return objectNode;
        }

        static List<Streams> getVideoModelStreamsList(JsonNode jsonNode, String string) {
            if (jsonNode.has(string)) {
                ArrayNode arrayNode = (ArrayNode)jsonNode.get(string);
                ArrayList<Streams> arrayList = new ArrayList<Streams>(arrayNode.size());
                for (int i = 0; i < arrayNode.size(); ++i) {
                    arrayList.add(new Streams(arrayNode.get(i)));
                }
                return arrayList;
            }
            return new ArrayList<Streams>(0);
        }

        public static class Video
        extends AbstractModel {
            public static final String ASPECT = "aspect";
            public static final String CODEC = "codec";
            public static final String DURATION = "duration";
            public static final String HEIGHT = "height";
            public static final String WIDTH = "width";
            public final Double aspect;
            public final String codec;
            public final Integer duration;
            public final Integer height;
            public final Integer width;

            public Video(Double d, String string, Integer n, Integer n2, Integer n3) {
                this.aspect = d;
                this.codec = string;
                this.duration = n;
                this.height = n2;
                this.width = n3;
            }

            public Video(JsonNode jsonNode) {
                this.aspect = Video.parseDouble(jsonNode, ASPECT);
                this.codec = Video.parseString(jsonNode, CODEC);
                this.duration = Video.parseInt(jsonNode, DURATION);
                this.height = Video.parseInt(jsonNode, HEIGHT);
                this.width = Video.parseInt(jsonNode, WIDTH);
            }

            @Override
            public JsonNode toJsonNode() {
                ObjectNode objectNode = OM.createObjectNode();
                objectNode.put(ASPECT, this.aspect);
                objectNode.put(CODEC, this.codec);
                objectNode.put(DURATION, this.duration);
                objectNode.put(HEIGHT, this.height);
                objectNode.put(WIDTH, this.width);
                return objectNode;
            }

            static List<Video> getVideoModelVideoList(JsonNode jsonNode, String string) {
                if (jsonNode.has(string)) {
                    ArrayNode arrayNode = (ArrayNode)jsonNode.get(string);
                    ArrayList<Video> arrayList = new ArrayList<Video>(arrayNode.size());
                    for (int i = 0; i < arrayNode.size(); ++i) {
                        arrayList.add(new Video(arrayNode.get(i)));
                    }
                    return arrayList;
                }
                return new ArrayList<Video>(0);
            }
        }

        public static class Subtitle
        extends AbstractModel {
            public static final String LANGUAGE = "language";
            public final String language;

            public Subtitle(String string) {
                this.language = string;
            }

            public Subtitle(JsonNode jsonNode) {
                this.language = Subtitle.parseString(jsonNode, LANGUAGE);
            }

            @Override
            public JsonNode toJsonNode() {
                ObjectNode objectNode = OM.createObjectNode();
                objectNode.put(LANGUAGE, this.language);
                return objectNode;
            }

            static List<Subtitle> getVideoModelSubtitleList(JsonNode jsonNode, String string) {
                if (jsonNode.has(string)) {
                    ArrayNode arrayNode = (ArrayNode)jsonNode.get(string);
                    ArrayList<Subtitle> arrayList = new ArrayList<Subtitle>(arrayNode.size());
                    for (int i = 0; i < arrayNode.size(); ++i) {
                        arrayList.add(new Subtitle(arrayNode.get(i)));
                    }
                    return arrayList;
                }
                return new ArrayList<Subtitle>(0);
            }
        }

        public static class Audio
        extends AbstractModel {
            public static final String CHANNELS = "channels";
            public static final String CODEC = "codec";
            public static final String LANGUAGE = "language";
            public final Integer channels;
            public final String codec;
            public final String language;

            public Audio(Integer n, String string, String string2) {
                this.channels = n;
                this.codec = string;
                this.language = string2;
            }

            public Audio(JsonNode jsonNode) {
                this.channels = Audio.parseInt(jsonNode, CHANNELS);
                this.codec = Audio.parseString(jsonNode, CODEC);
                this.language = Audio.parseString(jsonNode, LANGUAGE);
            }

            @Override
            public JsonNode toJsonNode() {
                ObjectNode objectNode = OM.createObjectNode();
                objectNode.put(CHANNELS, this.channels);
                objectNode.put(CODEC, this.codec);
                objectNode.put(LANGUAGE, this.language);
                return objectNode;
            }

            static List<Audio> getVideoModelAudioList(JsonNode jsonNode, String string) {
                if (jsonNode.has(string)) {
                    ArrayNode arrayNode = (ArrayNode)jsonNode.get(string);
                    ArrayList<Audio> arrayList = new ArrayList<Audio>(arrayNode.size());
                    for (int i = 0; i < arrayNode.size(); ++i) {
                        arrayList.add(new Audio(arrayNode.get(i)));
                    }
                    return arrayList;
                }
                return new ArrayList<Audio>(0);
            }
        }
    }

    public static class Resume
    extends AbstractModel {
        public static final String API_TYPE = "Video.Resume";
        public static final String POSITION = "position";
        public static final String TOTAL = "total";
        public final Double position;
        public final Double total;

        public Resume(Double d, Double d2) {
            this.position = d;
            this.total = d2;
        }

        public Resume(JsonNode jsonNode) {
            this.position = Resume.parseDouble(jsonNode, POSITION);
            this.total = Resume.parseDouble(jsonNode, TOTAL);
        }

        @Override
        public JsonNode toJsonNode() {
            ObjectNode objectNode = OM.createObjectNode();
            objectNode.put(POSITION, this.position);
            objectNode.put(TOTAL, this.total);
            return objectNode;
        }

        static List<Resume> getVideoModelResumeList(JsonNode jsonNode, String string) {
            if (jsonNode.has(string)) {
                ArrayNode arrayNode = (ArrayNode)jsonNode.get(string);
                ArrayList<Resume> arrayList = new ArrayList<Resume>(arrayNode.size());
                for (int i = 0; i < arrayNode.size(); ++i) {
                    arrayList.add(new Resume(arrayNode.get(i)));
                }
                return arrayList;
            }
            return new ArrayList<Resume>(0);
        }
    }

    public static class TVShowDetail
    extends ItemDetail {
        public static final String API_TYPE = "Video.Details.TVShow";
        public static final String CAST = "cast";
        public static final String EPISODE = "episode";
        public static final String EPISODEGUIDE = "episodeguide";
        public static final String GENRE = "genre";
        public static final String IMDBNUMBER = "imdbnumber";
        public static final String MPAA = "mpaa";
        public static final String ORIGINALTITLE = "originaltitle";
        public static final String PREMIERED = "premiered";
        public static final String RATING = "rating";
        public static final String SEASON = "season";
        public static final String SORTTITLE = "sorttitle";
        public static final String STUDIO = "studio";
        public static final String TAG = "tag";
        public static final String TVSHOWID = "tvshowid";
        public static final String USERRATING = "userrating";
        public static final String VOTES = "votes";
        public static final String WATCHEDEPISODES = "watchedepisodes";
        public static final String YEAR = "year";
        public final List<Cast> cast;
        public final Integer episode;
        public final String episodeguide;
        public final List<String> genre;
        public final String imdbnumber;
        public final String mpaa;
        public final String originaltitle;
        public final String premiered;
        public final Double rating;
        public final Integer season;
        public final String sorttitle;
        public final List<String> studio;
        public final List<String> tag;
        public final Integer tvshowid;
        public final Integer userrating;
        public final String votes;
        public final Integer watchedepisodes;
        public final Integer year;

        public TVShowDetail(JsonNode jsonNode) {
            super(jsonNode);
            this.cast = Cast.getVideoModelCastList(jsonNode, CAST);
            this.episode = TVShowDetail.parseInt(jsonNode, EPISODE);
            this.episodeguide = TVShowDetail.parseString(jsonNode, EPISODEGUIDE);
            this.genre = TVShowDetail.getStringArray(jsonNode, GENRE);
            this.imdbnumber = TVShowDetail.parseString(jsonNode, IMDBNUMBER);
            this.mpaa = TVShowDetail.parseString(jsonNode, MPAA);
            this.originaltitle = TVShowDetail.parseString(jsonNode, ORIGINALTITLE);
            this.premiered = TVShowDetail.parseString(jsonNode, PREMIERED);
            this.rating = TVShowDetail.parseDouble(jsonNode, RATING);
            this.season = TVShowDetail.parseInt(jsonNode, SEASON);
            this.sorttitle = TVShowDetail.parseString(jsonNode, SORTTITLE);
            this.studio = TVShowDetail.getStringArray(jsonNode, STUDIO);
            this.tag = TVShowDetail.getStringArray(jsonNode, TAG);
            this.tvshowid = TVShowDetail.parseInt(jsonNode, TVSHOWID);
            this.userrating = TVShowDetail.parseInt(jsonNode, USERRATING);
            this.votes = TVShowDetail.parseString(jsonNode, VOTES);
            this.watchedepisodes = TVShowDetail.parseInt(jsonNode, WATCHEDEPISODES);
            this.year = TVShowDetail.parseInt(jsonNode, YEAR);
        }

        @Override
        public JsonNode toJsonNode() {
            ObjectNode objectNode = (ObjectNode)super.toJsonNode();
            ArrayNode arrayNode = OM.createArrayNode();
            for (Cast object22 : this.cast) {
                arrayNode.add(object22.toJsonNode());
            }
            objectNode.put(CAST, (JsonNode)arrayNode);
            objectNode.put(EPISODE, this.episode);
            objectNode.put(EPISODEGUIDE, this.episodeguide);
            ArrayNode arrayNode2 = OM.createArrayNode();
            for (String string : this.genre) {
                arrayNode2.add(string);
            }
            objectNode.put(GENRE, (JsonNode)arrayNode2);
            objectNode.put(IMDBNUMBER, this.imdbnumber);
            objectNode.put(MPAA, this.mpaa);
            objectNode.put(ORIGINALTITLE, this.originaltitle);
            objectNode.put(PREMIERED, this.premiered);
            objectNode.put(RATING, this.rating);
            objectNode.put(SEASON, this.season);
            objectNode.put(SORTTITLE, this.sorttitle);
            ArrayNode arrayNode3 = OM.createArrayNode();
            for (String string : this.studio) {
                arrayNode3.add(string);
            }
            objectNode.put(STUDIO, (JsonNode)arrayNode3);
            ArrayNode arrayNode4 = OM.createArrayNode();
            for (String string : this.tag) {
                arrayNode4.add(string);
            }
            objectNode.put(TAG, (JsonNode)arrayNode4);
            objectNode.put(TVSHOWID, this.tvshowid);
            objectNode.put(USERRATING, this.userrating);
            objectNode.put(VOTES, this.votes);
            objectNode.put(WATCHEDEPISODES, this.watchedepisodes);
            objectNode.put(YEAR, this.year);
            return objectNode;
        }

        static List<TVShowDetail> getVideoModelTVShowDetailList(JsonNode jsonNode, String string) {
            if (jsonNode.has(string)) {
                ArrayNode arrayNode = (ArrayNode)jsonNode.get(string);
                ArrayList<TVShowDetail> arrayList = new ArrayList<TVShowDetail>(arrayNode.size());
                for (int i = 0; i < arrayNode.size(); ++i) {
                    arrayList.add(new TVShowDetail(arrayNode.get(i)));
                }
                return arrayList;
            }
            return new ArrayList<TVShowDetail>(0);
        }
    }

    public static class SeasonDetail
    extends BaseDetail {
        public static final String API_TYPE = "Video.Details.Season";
        public static final String EPISODE = "episode";
        public static final String SEASON = "season";
        public static final String SEASONID = "seasonid";
        public static final String SHOWTITLE = "showtitle";
        public static final String TVSHOWID = "tvshowid";
        public static final String WATCHEDEPISODES = "watchedepisodes";
        public final Integer episode;
        public final Integer season;
        public final Integer seasonid;
        public final String showtitle;
        public final Integer tvshowid;
        public final Integer watchedepisodes;

        public SeasonDetail(JsonNode jsonNode) {
            super(jsonNode);
            this.episode = SeasonDetail.parseInt(jsonNode, EPISODE);
            this.season = jsonNode.get(SEASON).getIntValue();
            this.seasonid = SeasonDetail.parseInt(jsonNode, SEASONID);
            this.showtitle = SeasonDetail.parseString(jsonNode, SHOWTITLE);
            this.tvshowid = SeasonDetail.parseInt(jsonNode, TVSHOWID);
            this.watchedepisodes = SeasonDetail.parseInt(jsonNode, WATCHEDEPISODES);
        }

        @Override
        public JsonNode toJsonNode() {
            ObjectNode objectNode = (ObjectNode)super.toJsonNode();
            objectNode.put(EPISODE, this.episode);
            objectNode.put(SEASON, this.season);
            objectNode.put(SEASONID, this.seasonid);
            objectNode.put(SHOWTITLE, this.showtitle);
            objectNode.put(TVSHOWID, this.tvshowid);
            objectNode.put(WATCHEDEPISODES, this.watchedepisodes);
            return objectNode;
        }

        static List<SeasonDetail> getVideoModelSeasonDetailList(JsonNode jsonNode, String string) {
            if (jsonNode.has(string)) {
                ArrayNode arrayNode = (ArrayNode)jsonNode.get(string);
                ArrayList<SeasonDetail> arrayList = new ArrayList<SeasonDetail>(arrayNode.size());
                for (int i = 0; i < arrayNode.size(); ++i) {
                    arrayList.add(new SeasonDetail(arrayNode.get(i)));
                }
                return arrayList;
            }
            return new ArrayList<SeasonDetail>(0);
        }
    }

    public static class MusicVideoDetail
    extends FileDetail {
        public static final String API_TYPE = "Video.Details.MusicVideo";
        public static final String ALBUM = "album";
        public static final String ARTIST = "artist";
        public static final String GENRE = "genre";
        public static final String MUSICVIDEOID = "musicvideoid";
        public static final String STUDIO = "studio";
        public static final String TAG = "tag";
        public static final String TRACK = "track";
        public static final String USERRATING = "userrating";
        public static final String YEAR = "year";
        public final String album;
        public final List<String> artist;
        public final List<String> genre;
        public final Integer musicvideoid;
        public final List<String> studio;
        public final List<String> tag;
        public final Integer track;
        public final Integer userrating;
        public final Integer year;

        public MusicVideoDetail(JsonNode jsonNode) {
            super(jsonNode);
            this.album = MusicVideoDetail.parseString(jsonNode, ALBUM);
            this.artist = MusicVideoDetail.getStringArray(jsonNode, ARTIST);
            this.genre = MusicVideoDetail.getStringArray(jsonNode, GENRE);
            this.musicvideoid = MusicVideoDetail.parseInt(jsonNode, MUSICVIDEOID);
            this.studio = MusicVideoDetail.getStringArray(jsonNode, STUDIO);
            this.tag = MusicVideoDetail.getStringArray(jsonNode, TAG);
            this.track = MusicVideoDetail.parseInt(jsonNode, TRACK);
            this.userrating = MusicVideoDetail.parseInt(jsonNode, USERRATING);
            this.year = MusicVideoDetail.parseInt(jsonNode, YEAR);
        }

        @Override
        public JsonNode toJsonNode() {
            ObjectNode objectNode = (ObjectNode)super.toJsonNode();
            objectNode.put(ALBUM, this.album);
            ArrayNode arrayNode = OM.createArrayNode();
            for (String object22 : this.artist) {
                arrayNode.add(object22);
            }
            objectNode.put(ARTIST, (JsonNode)arrayNode);
            ArrayNode arrayNode2 = OM.createArrayNode();
            for (String string : this.genre) {
                arrayNode2.add(string);
            }
            objectNode.put(GENRE, (JsonNode)arrayNode2);
            objectNode.put(MUSICVIDEOID, this.musicvideoid);
            ArrayNode arrayNode3 = OM.createArrayNode();
            for (String string : this.studio) {
                arrayNode3.add(string);
            }
            objectNode.put(STUDIO, (JsonNode)arrayNode3);
            ArrayNode arrayNode4 = OM.createArrayNode();
            for (String string : this.tag) {
                arrayNode4.add(string);
            }
            objectNode.put(TAG, (JsonNode)arrayNode4);
            objectNode.put(TRACK, this.track);
            objectNode.put(USERRATING, this.userrating);
            objectNode.put(YEAR, this.year);
            return objectNode;
        }

        static List<MusicVideoDetail> getVideoModelMusicVideoDetailList(JsonNode jsonNode, String string) {
            if (jsonNode.has(string)) {
                ArrayNode arrayNode = (ArrayNode)jsonNode.get(string);
                ArrayList<MusicVideoDetail> arrayList = new ArrayList<MusicVideoDetail>(arrayNode.size());
                for (int i = 0; i < arrayNode.size(); ++i) {
                    arrayList.add(new MusicVideoDetail(arrayNode.get(i)));
                }
                return arrayList;
            }
            return new ArrayList<MusicVideoDetail>(0);
        }
    }

    public static class MovieSetExtendedDetail
    extends MovieSetDetail {
        public static final String API_TYPE = "Video.Details.MovieSet.Extended";
        public static final String LIMITS = "limits";
        public static final String MOVIES = "movies";
        public final ListModel.LimitsReturned limits;
        public final List<MovieDetail> movies;

        public MovieSetExtendedDetail(JsonNode jsonNode) {
            super(jsonNode);
            this.limits = jsonNode.has(LIMITS) ? new ListModel.LimitsReturned(jsonNode.get(LIMITS)) : null;
            this.movies = MovieDetail.getVideoModelMovieDetailList(jsonNode, MOVIES);
        }

        @Override
        public JsonNode toJsonNode() {
            ObjectNode objectNode = (ObjectNode)super.toJsonNode();
            objectNode.put(LIMITS, this.limits == null ? null : this.limits.toJsonNode());
            ArrayNode arrayNode = OM.createArrayNode();
            for (MovieDetail movieDetail : this.movies) {
                arrayNode.add(movieDetail.toJsonNode());
            }
            objectNode.put(MOVIES, (JsonNode)arrayNode);
            return objectNode;
        }

        static List<MovieSetExtendedDetail> getVideoModelMovieSetExtendedDetailList(JsonNode jsonNode, String string) {
            if (jsonNode.has(string)) {
                ArrayNode arrayNode = (ArrayNode)jsonNode.get(string);
                ArrayList<MovieSetExtendedDetail> arrayList = new ArrayList<MovieSetExtendedDetail>(arrayNode.size());
                for (int i = 0; i < arrayNode.size(); ++i) {
                    arrayList.add(new MovieSetExtendedDetail(arrayNode.get(i)));
                }
                return arrayList;
            }
            return new ArrayList<MovieSetExtendedDetail>(0);
        }
    }

    public static class MovieSetDetail
    extends MediaDetail {
        public static final String API_TYPE = "Video.Details.MovieSet";
        public static final String PLOT = "plot";
        public static final String SETID = "setid";
        public final String plot;
        public final Integer setid;

        public MovieSetDetail(JsonNode jsonNode) {
            super(jsonNode);
            this.plot = MovieSetDetail.parseString(jsonNode, PLOT);
            this.setid = MovieSetDetail.parseInt(jsonNode, SETID);
        }

        @Override
        public JsonNode toJsonNode() {
            ObjectNode objectNode = (ObjectNode)super.toJsonNode();
            objectNode.put(PLOT, this.plot);
            objectNode.put(SETID, this.setid);
            return objectNode;
        }

        static List<MovieSetDetail> getVideoModelMovieSetDetailList(JsonNode jsonNode, String string) {
            if (jsonNode.has(string)) {
                ArrayNode arrayNode = (ArrayNode)jsonNode.get(string);
                ArrayList<MovieSetDetail> arrayList = new ArrayList<MovieSetDetail>(arrayNode.size());
                for (int i = 0; i < arrayNode.size(); ++i) {
                    arrayList.add(new MovieSetDetail(arrayNode.get(i)));
                }
                return arrayList;
            }
            return new ArrayList<MovieSetDetail>(0);
        }
    }

    public static class MovieDetail
    extends FileDetail {
        public static final String API_TYPE = "Video.Details.Movie";
        public static final String CAST = "cast";
        public static final String COUNTRY = "country";
        public static final String GENRE = "genre";
        public static final String IMDBNUMBER = "imdbnumber";
        public static final String MOVIEID = "movieid";
        public static final String MPAA = "mpaa";
        public static final String ORIGINALTITLE = "originaltitle";
        public static final String PLOTOUTLINE = "plotoutline";
        public static final String RATING = "rating";
        public static final String SET = "set";
        public static final String SETID = "setid";
        public static final String SHOWLINK = "showlink";
        public static final String SORTTITLE = "sorttitle";
        public static final String STUDIO = "studio";
        public static final String TAG = "tag";
        public static final String TAGLINE = "tagline";
        public static final String TOP250 = "top250";
        public static final String TRAILER = "trailer";
        public static final String USERRATING = "userrating";
        public static final String VOTES = "votes";
        public static final String WRITER = "writer";
        public static final String YEAR = "year";
        public final List<Cast> cast;
        public final List<String> country;
        public final List<String> genre;
        public final String imdbnumber;
        public final Integer movieid;
        public final String mpaa;
        public final String originaltitle;
        public final String plotoutline;
        public final Double rating;
        public final String set;
        public final Integer setid;
        public final List<String> showlink;
        public final String sorttitle;
        public final List<String> studio;
        public final List<String> tag;
        public final String tagline;
        public final Integer top250;
        public final String trailer;
        public final Integer userrating;
        public final String votes;
        public final List<String> writer;
        public final Integer year;

        public MovieDetail(JsonNode jsonNode) {
            super(jsonNode);
            this.cast = Cast.getVideoModelCastList(jsonNode, CAST);
            this.country = MovieDetail.getStringArray(jsonNode, COUNTRY);
            this.genre = MovieDetail.getStringArray(jsonNode, GENRE);
            this.imdbnumber = MovieDetail.parseString(jsonNode, IMDBNUMBER);
            this.movieid = MovieDetail.parseInt(jsonNode, MOVIEID);
            this.mpaa = MovieDetail.parseString(jsonNode, MPAA);
            this.originaltitle = MovieDetail.parseString(jsonNode, ORIGINALTITLE);
            this.plotoutline = MovieDetail.parseString(jsonNode, PLOTOUTLINE);
            this.rating = MovieDetail.parseDouble(jsonNode, RATING);
            this.set = MovieDetail.parseString(jsonNode, SET);
            this.setid = MovieDetail.parseInt(jsonNode, SETID);
            this.showlink = MovieDetail.getStringArray(jsonNode, SHOWLINK);
            this.sorttitle = MovieDetail.parseString(jsonNode, SORTTITLE);
            this.studio = MovieDetail.getStringArray(jsonNode, STUDIO);
            this.tag = MovieDetail.getStringArray(jsonNode, TAG);
            this.tagline = MovieDetail.parseString(jsonNode, TAGLINE);
            this.top250 = MovieDetail.parseInt(jsonNode, TOP250);
            this.trailer = MovieDetail.parseString(jsonNode, TRAILER);
            this.userrating = MovieDetail.parseInt(jsonNode, USERRATING);
            this.votes = MovieDetail.parseString(jsonNode, VOTES);
            this.writer = MovieDetail.getStringArray(jsonNode, WRITER);
            this.year = MovieDetail.parseInt(jsonNode, YEAR);
        }

        @Override
        public JsonNode toJsonNode() {
            ObjectNode objectNode = (ObjectNode)super.toJsonNode();
            ArrayNode arrayNode = OM.createArrayNode();
            for (Cast object52 : this.cast) {
                arrayNode.add(object52.toJsonNode());
            }
            objectNode.put(CAST, (JsonNode)arrayNode);
            ArrayNode arrayNode2 = OM.createArrayNode();
            for (String string : this.country) {
                arrayNode2.add(string);
            }
            objectNode.put(COUNTRY, (JsonNode)arrayNode2);
            ArrayNode arrayNode3 = OM.createArrayNode();
            for (String string : this.genre) {
                arrayNode3.add(string);
            }
            objectNode.put(GENRE, (JsonNode)arrayNode3);
            objectNode.put(IMDBNUMBER, this.imdbnumber);
            objectNode.put(MOVIEID, this.movieid);
            objectNode.put(MPAA, this.mpaa);
            objectNode.put(ORIGINALTITLE, this.originaltitle);
            objectNode.put(PLOTOUTLINE, this.plotoutline);
            objectNode.put(RATING, this.rating);
            objectNode.put(SET, this.set);
            objectNode.put(SETID, this.setid);
            ArrayNode arrayNode4 = OM.createArrayNode();
            for (String string : this.showlink) {
                arrayNode4.add(string);
            }
            objectNode.put(SHOWLINK, (JsonNode)arrayNode4);
            objectNode.put(SORTTITLE, this.sorttitle);
            ArrayNode arrayNode5 = OM.createArrayNode();
            for (String string : this.studio) {
                arrayNode5.add(string);
            }
            objectNode.put(STUDIO, (JsonNode)arrayNode5);
            ArrayNode arrayNode6 = OM.createArrayNode();
            for (String string : this.tag) {
                arrayNode6.add(string);
            }
            objectNode.put(TAG, (JsonNode)arrayNode6);
            objectNode.put(TAGLINE, this.tagline);
            objectNode.put(TOP250, this.top250);
            objectNode.put(TRAILER, this.trailer);
            objectNode.put(USERRATING, this.userrating);
            objectNode.put(VOTES, this.votes);
            ArrayNode arrayNode7 = OM.createArrayNode();
            for (String string : this.writer) {
                arrayNode7.add(string);
            }
            objectNode.put(WRITER, (JsonNode)arrayNode7);
            objectNode.put(YEAR, this.year);
            return objectNode;
        }

        static List<MovieDetail> getVideoModelMovieDetailList(JsonNode jsonNode, String string) {
            if (jsonNode.has(string)) {
                ArrayNode arrayNode = (ArrayNode)jsonNode.get(string);
                ArrayList<MovieDetail> arrayList = new ArrayList<MovieDetail>(arrayNode.size());
                for (int i = 0; i < arrayNode.size(); ++i) {
                    arrayList.add(new MovieDetail(arrayNode.get(i)));
                }
                return arrayList;
            }
            return new ArrayList<MovieDetail>(0);
        }
    }

    public static class MediaDetail
    extends BaseDetail {
        public static final String API_TYPE = "Video.Details.Media";
        public static final String TITLE = "title";
        public final String title;

        public MediaDetail(JsonNode jsonNode) {
            super(jsonNode);
            this.title = MediaDetail.parseString(jsonNode, TITLE);
        }

        @Override
        public JsonNode toJsonNode() {
            ObjectNode objectNode = (ObjectNode)super.toJsonNode();
            objectNode.put(TITLE, this.title);
            return objectNode;
        }

        static List<MediaDetail> getVideoModelMediaDetailList(JsonNode jsonNode, String string) {
            if (jsonNode.has(string)) {
                ArrayNode arrayNode = (ArrayNode)jsonNode.get(string);
                ArrayList<MediaDetail> arrayList = new ArrayList<MediaDetail>(arrayNode.size());
                for (int i = 0; i < arrayNode.size(); ++i) {
                    arrayList.add(new MediaDetail(arrayNode.get(i)));
                }
                return arrayList;
            }
            return new ArrayList<MediaDetail>(0);
        }
    }

    public static class ItemDetail
    extends MediaDetail {
        public static final String API_TYPE = "Video.Details.Item";
        public static final String DATEADDED = "dateadded";
        public static final String FILE = "file";
        public static final String LASTPLAYED = "lastplayed";
        public static final String PLOT = "plot";
        public final String dateadded;
        public final String file;
        public final String lastplayed;
        public final String plot;

        public ItemDetail(JsonNode jsonNode) {
            super(jsonNode);
            this.dateadded = ItemDetail.parseString(jsonNode, DATEADDED);
            this.file = ItemDetail.parseString(jsonNode, FILE);
            this.lastplayed = ItemDetail.parseString(jsonNode, LASTPLAYED);
            this.plot = ItemDetail.parseString(jsonNode, PLOT);
        }

        @Override
        public JsonNode toJsonNode() {
            ObjectNode objectNode = (ObjectNode)super.toJsonNode();
            objectNode.put(DATEADDED, this.dateadded);
            objectNode.put(FILE, this.file);
            objectNode.put(LASTPLAYED, this.lastplayed);
            objectNode.put(PLOT, this.plot);
            return objectNode;
        }

        static List<ItemDetail> getVideoModelItemDetailList(JsonNode jsonNode, String string) {
            if (jsonNode.has(string)) {
                ArrayNode arrayNode = (ArrayNode)jsonNode.get(string);
                ArrayList<ItemDetail> arrayList = new ArrayList<ItemDetail>(arrayNode.size());
                for (int i = 0; i < arrayNode.size(); ++i) {
                    arrayList.add(new ItemDetail(arrayNode.get(i)));
                }
                return arrayList;
            }
            return new ArrayList<ItemDetail>(0);
        }
    }

    public static class FileDetail
    extends ItemDetail {
        public static final String API_TYPE = "Video.Details.File";
        public static final String DIRECTOR = "director";
        public static final String RESUME = "resume";
        public static final String RUNTIME = "runtime";
        public static final String STREAMDETAILS = "streamdetails";
        public final List<String> director;
        public final Resume resume;
        public final Integer runtime;
        public final Streams streamdetails;

        public FileDetail(JsonNode jsonNode) {
            super(jsonNode);
            this.director = FileDetail.getStringArray(jsonNode, DIRECTOR);
            this.resume = jsonNode.has(RESUME) ? new Resume(jsonNode.get(RESUME)) : null;
            this.runtime = FileDetail.parseInt(jsonNode, RUNTIME);
            this.streamdetails = jsonNode.has(STREAMDETAILS) ? new Streams(jsonNode.get(STREAMDETAILS)) : null;
        }

        @Override
        public JsonNode toJsonNode() {
            ObjectNode objectNode = (ObjectNode)super.toJsonNode();
            ArrayNode arrayNode = OM.createArrayNode();
            for (String string : this.director) {
                arrayNode.add(string);
            }
            objectNode.put(DIRECTOR, (JsonNode)arrayNode);
            objectNode.put(RESUME, this.resume == null ? null : this.resume.toJsonNode());
            objectNode.put(RUNTIME, this.runtime);
            objectNode.put(STREAMDETAILS, this.streamdetails == null ? null : this.streamdetails.toJsonNode());
            return objectNode;
        }

        static List<FileDetail> getVideoModelFileDetailList(JsonNode jsonNode, String string) {
            if (jsonNode.has(string)) {
                ArrayNode arrayNode = (ArrayNode)jsonNode.get(string);
                ArrayList<FileDetail> arrayList = new ArrayList<FileDetail>(arrayNode.size());
                for (int i = 0; i < arrayNode.size(); ++i) {
                    arrayList.add(new FileDetail(arrayNode.get(i)));
                }
                return arrayList;
            }
            return new ArrayList<FileDetail>(0);
        }
    }

    public static class EpisodeDetail
    extends FileDetail {
        public static final String API_TYPE = "Video.Details.Episode";
        public static final String CAST = "cast";
        public static final String EPISODE = "episode";
        public static final String EPISODEID = "episodeid";
        public static final String FIRSTAIRED = "firstaired";
        public static final String ORIGINALTITLE = "originaltitle";
        public static final String PRODUCTIONCODE = "productioncode";
        public static final String RATING = "rating";
        public static final String SEASON = "season";
        public static final String SEASONID = "seasonid";
        public static final String SHOWTITLE = "showtitle";
        public static final String SPECIALSORTEPISODE = "specialsortepisode";
        public static final String SPECIALSORTSEASON = "specialsortseason";
        public static final String TVSHOWID = "tvshowid";
        public static final String UNIQUEID = "uniqueid";
        public static final String USERRATING = "userrating";
        public static final String VOTES = "votes";
        public static final String WRITER = "writer";
        public final List<Cast> cast;
        public final Integer episode;
        public final Integer episodeid;
        public final String firstaired;
        public final String originaltitle;
        public final String productioncode;
        public final Double rating;
        public final Integer season;
        public final Integer seasonid;
        public final String showtitle;
        public final Integer specialsortepisode;
        public final Integer specialsortseason;
        public final Integer tvshowid;
        public final HashMap<String, String> uniqueid;
        public final Integer userrating;
        public final String votes;
        public final List<String> writer;

        public EpisodeDetail(JsonNode jsonNode) {
            super(jsonNode);
            this.cast = Cast.getVideoModelCastList(jsonNode, CAST);
            this.episode = EpisodeDetail.parseInt(jsonNode, EPISODE);
            this.episodeid = EpisodeDetail.parseInt(jsonNode, EPISODEID);
            this.firstaired = EpisodeDetail.parseString(jsonNode, FIRSTAIRED);
            this.originaltitle = EpisodeDetail.parseString(jsonNode, ORIGINALTITLE);
            this.productioncode = EpisodeDetail.parseString(jsonNode, PRODUCTIONCODE);
            this.rating = EpisodeDetail.parseDouble(jsonNode, RATING);
            this.season = EpisodeDetail.parseInt(jsonNode, SEASON);
            this.seasonid = EpisodeDetail.parseInt(jsonNode, SEASONID);
            this.showtitle = EpisodeDetail.parseString(jsonNode, SHOWTITLE);
            this.specialsortepisode = EpisodeDetail.parseInt(jsonNode, SPECIALSORTEPISODE);
            this.specialsortseason = EpisodeDetail.parseInt(jsonNode, SPECIALSORTSEASON);
            this.tvshowid = EpisodeDetail.parseInt(jsonNode, TVSHOWID);
            this.uniqueid = EpisodeDetail.getStringMap(jsonNode, UNIQUEID);
            this.userrating = EpisodeDetail.parseInt(jsonNode, USERRATING);
            this.votes = EpisodeDetail.parseString(jsonNode, VOTES);
            this.writer = EpisodeDetail.getStringArray(jsonNode, WRITER);
        }

        @Override
        public JsonNode toJsonNode() {
            ObjectNode objectNode = (ObjectNode)super.toJsonNode();
            ArrayNode arrayNode = OM.createArrayNode();
            for (Cast object2 : this.cast) {
                arrayNode.add(object2.toJsonNode());
            }
            objectNode.put(CAST, (JsonNode)arrayNode);
            objectNode.put(EPISODE, this.episode);
            objectNode.put(EPISODEID, this.episodeid);
            objectNode.put(FIRSTAIRED, this.firstaired);
            objectNode.put(ORIGINALTITLE, this.originaltitle);
            objectNode.put(PRODUCTIONCODE, this.productioncode);
            objectNode.put(RATING, this.rating);
            objectNode.put(SEASON, this.season);
            objectNode.put(SEASONID, this.seasonid);
            objectNode.put(SHOWTITLE, this.showtitle);
            objectNode.put(SPECIALSORTEPISODE, this.specialsortepisode);
            objectNode.put(SPECIALSORTSEASON, this.specialsortseason);
            objectNode.put(TVSHOWID, this.tvshowid);
            ObjectNode objectNode2 = OM.createObjectNode();
            for (String string : this.uniqueid.values()) {
                objectNode2.put(string, this.uniqueid.get(string));
            }
            objectNode.put(UNIQUEID, (JsonNode)objectNode2);
            objectNode.put(USERRATING, this.userrating);
            objectNode.put(VOTES, this.votes);
            ArrayNode arrayNode2 = OM.createArrayNode();
            for (String string : this.writer) {
                arrayNode2.add(string);
            }
            objectNode.put(WRITER, (JsonNode)arrayNode2);
            return objectNode;
        }

        static List<EpisodeDetail> getVideoModelEpisodeDetailList(JsonNode jsonNode, String string) {
            if (jsonNode.has(string)) {
                ArrayNode arrayNode = (ArrayNode)jsonNode.get(string);
                ArrayList<EpisodeDetail> arrayList = new ArrayList<EpisodeDetail>(arrayNode.size());
                for (int i = 0; i < arrayNode.size(); ++i) {
                    arrayList.add(new EpisodeDetail(arrayNode.get(i)));
                }
                return arrayList;
            }
            return new ArrayList<EpisodeDetail>(0);
        }
    }

    public static class BaseDetail
    extends MediaModel.BaseDetail {
        public static final String API_TYPE = "Video.Details.Base";
        public static final String ART = "art";
        public static final String PLAYCOUNT = "playcount";
        public final MediaModel.Artwork art;
        public final Integer playcount;

        public BaseDetail(JsonNode jsonNode) {
            super(jsonNode);
            this.art = jsonNode.has(ART) ? new MediaModel.Artwork(jsonNode.get(ART)) : null;
            this.playcount = BaseDetail.parseInt(jsonNode, PLAYCOUNT);
        }

        @Override
        public JsonNode toJsonNode() {
            ObjectNode objectNode = (ObjectNode)super.toJsonNode();
            objectNode.put(ART, this.art == null ? null : this.art.toJsonNode());
            objectNode.put(PLAYCOUNT, this.playcount);
            return objectNode;
        }

        static List<BaseDetail> getVideoModelBaseDetailList(JsonNode jsonNode, String string) {
            if (jsonNode.has(string)) {
                ArrayNode arrayNode = (ArrayNode)jsonNode.get(string);
                ArrayList<BaseDetail> arrayList = new ArrayList<BaseDetail>(arrayNode.size());
                for (int i = 0; i < arrayNode.size(); ++i) {
                    arrayList.add(new BaseDetail(arrayNode.get(i)));
                }
                return arrayList;
            }
            return new ArrayList<BaseDetail>(0);
        }
    }

    public static class Cast
    extends AbstractModel {
        public static final String NAME = "name";
        public static final String ORDER = "order";
        public static final String ROLE = "role";
        public static final String THUMBNAIL = "thumbnail";
        public final String name;
        public final Integer order;
        public final String role;
        public final String thumbnail;

        public Cast(String string, Integer n, String string2, String string3) {
            this.name = string;
            this.order = n;
            this.role = string2;
            this.thumbnail = string3;
        }

        public Cast(JsonNode jsonNode) {
            this.name = jsonNode.get(NAME).getTextValue();
            this.order = jsonNode.get(ORDER).getIntValue();
            this.role = jsonNode.get(ROLE).getTextValue();
            this.thumbnail = Cast.parseString(jsonNode, THUMBNAIL);
        }

        @Override
        public JsonNode toJsonNode() {
            ObjectNode objectNode = OM.createObjectNode();
            objectNode.put(NAME, this.name);
            objectNode.put(ORDER, this.order);
            objectNode.put(ROLE, this.role);
            objectNode.put(THUMBNAIL, this.thumbnail);
            return objectNode;
        }

        static List<Cast> getVideoModelCastList(JsonNode jsonNode, String string) {
            if (jsonNode.has(string)) {
                ArrayNode arrayNode = (ArrayNode)jsonNode.get(string);
                ArrayList<Cast> arrayList = new ArrayList<Cast>(arrayNode.size());
                for (int i = 0; i < arrayNode.size(); ++i) {
                    arrayList.add(new Cast(arrayNode.get(i)));
                }
                return arrayList;
            }
            return new ArrayList<Cast>(0);
        }
    }
}

