/*
 * Decompiled with CFR 0.152.
 */
package org.tinymediamanager.jsonrpc.notification;

import org.codehaus.jackson.JsonNode;
import org.codehaus.jackson.node.ObjectNode;
import org.tinymediamanager.jsonrpc.api.model.GlobalModel;
import org.tinymediamanager.jsonrpc.notification.AbstractEvent;

public class PlayerEvent {

    public static class PlayerSeek
    extends Player {
        public static final String TYPE = "Player.Notifications.Player.Seek";
        public final GlobalModel.Time time;
        public final GlobalModel.Time seekoffset;

        public PlayerSeek(ObjectNode objectNode) {
            super(objectNode);
            this.time = new GlobalModel.Time((JsonNode)((ObjectNode)objectNode.get("time")));
            this.seekoffset = new GlobalModel.Time((JsonNode)((ObjectNode)objectNode.get("seekoffset")));
        }
    }

    public static class Player {
        public static final String TYPE = "Player.Notifications.Player";
        public final int playerId;
        public final int speed;

        public Player(ObjectNode objectNode) {
            this.playerId = objectNode.get("playerid").getIntValue();
            this.speed = objectNode.get("speed").getValueAsInt(0);
        }
    }

    public static class Item {
        public static final String TYPE = "Player.Notifications.Item";
        public final int type;
        public final int id;
        public final String title;
        public final int year;
        public final int episode;
        public final int season;
        public final String showtitle;
        public final String album;
        public final String artist;
        public final int track;

        public Item(ObjectNode objectNode) {
            this.type = Type.parse(objectNode.get("type").getTextValue());
            this.id = AbstractEvent.parseInt(objectNode, "id");
            this.title = AbstractEvent.parseString(objectNode, "title");
            this.year = AbstractEvent.parseInt(objectNode, "year");
            this.episode = AbstractEvent.parseInt(objectNode, "episode");
            this.season = AbstractEvent.parseInt(objectNode, "season");
            this.showtitle = AbstractEvent.parseString(objectNode, "showtitle");
            this.album = AbstractEvent.parseString(objectNode, "album");
            this.artist = AbstractEvent.parseString(objectNode, "artist");
            this.track = AbstractEvent.parseInt(objectNode, "track");
        }

        public String toString() {
            return Type.stringValue(this.type) + "(" + this.id + ")";
        }

        public static class Type {
            public static final int UNKNOWN = 0;
            public static final int MOVIE = 1;
            public static final int EPISODE = 2;
            public static final int MUSICVIDEO = 3;
            public static final int SONG = 4;

            public static int parse(String string) {
                if (string.equals("unknown")) {
                    return 0;
                }
                if (string.equals("movie")) {
                    return 1;
                }
                if (string.equals("episode")) {
                    return 2;
                }
                if (string.equals("musicvideo")) {
                    return 3;
                }
                if (string.equals("song")) {
                    return 4;
                }
                return 0;
            }

            public static String stringValue(int n) {
                switch (n) {
                    case 1: {
                        return "Movie";
                    }
                    case 2: {
                        return "Episode";
                    }
                    case 3: {
                        return "Musicvideo";
                    }
                    case 4: {
                        return "Song";
                    }
                }
                return "Unknown";
            }
        }
    }

    public static class Data {
        public static final String TYPE = "Player.Notifications.Data";
        public final Item item;
        public final Player player;

        public Data(ObjectNode objectNode) {
            this.item = new Item((ObjectNode)objectNode.get("item"));
            this.player = new Player((ObjectNode)objectNode.get("player"));
        }
    }

    public static class Seek
    extends AbstractEvent {
        public static final int ID = 5;
        public static final String METHOD = "Player.OnSeek";
        public final Data data;

        public Seek(ObjectNode objectNode) {
            super(objectNode);
            this.data = new Data((ObjectNode)objectNode.get("data"));
        }

        public String toString() {
            return "SEEK: Item " + this.data.item + " with player " + this.data.player.playerId + " to " + this.data.player.time + " at " + this.data.player.seekoffset + ".";
        }

        @Override
        public int getId() {
            return 5;
        }

        @Override
        public String getMethod() {
            return METHOD;
        }

        public static class Data {
            public final Item item;
            public final PlayerSeek player;

            public Data(ObjectNode objectNode) {
                this.item = new Item((ObjectNode)objectNode.get("item"));
                this.player = new PlayerSeek((ObjectNode)objectNode.get("player"));
            }
        }
    }

    public static class SpeedChanged
    extends AbstractEvent {
        public static final int ID = 4;
        public static final String METHOD = "Player.OnSpeedChanged";
        public final Data data;

        public SpeedChanged(ObjectNode objectNode) {
            super(objectNode);
            this.data = new Data((ObjectNode)objectNode.get("data"));
        }

        public String toString() {
            return "SPEED-CHANGE: Item " + this.data.item + " with player " + this.data.player.playerId + " at speed " + this.data.player.speed + ".";
        }

        @Override
        public int getId() {
            return 4;
        }

        @Override
        public String getMethod() {
            return METHOD;
        }
    }

    public static class Stop
    extends AbstractEvent {
        public static final int ID = 3;
        public static final String METHOD = "Player.OnStop";
        public final Data data;

        public Stop(ObjectNode objectNode) {
            super(objectNode);
            this.data = new Data((ObjectNode)objectNode.get("data"));
        }

        public String toString() {
            return "STOP: Item " + this.data.item + ".";
        }

        @Override
        public int getId() {
            return 3;
        }

        @Override
        public String getMethod() {
            return METHOD;
        }

        public static class Data {
            public final Item item;

            public Data(ObjectNode objectNode) {
                this.item = new Item((ObjectNode)objectNode.get("item"));
            }
        }
    }

    public static class Pause
    extends AbstractEvent {
        public static final int ID = 2;
        public static final String METHOD = "Player.OnPause";
        public final Data data;

        public Pause(ObjectNode objectNode) {
            super(objectNode);
            this.data = new Data((ObjectNode)objectNode.get("data"));
        }

        public String toString() {
            return "PAUSE: Item " + this.data.item + " with player " + this.data.player.playerId + " at speed " + this.data.player.speed + ".";
        }

        @Override
        public int getId() {
            return 2;
        }

        @Override
        public String getMethod() {
            return METHOD;
        }
    }

    public static class Play
    extends AbstractEvent {
        public static final int ID = 1;
        public static final String METHOD = "Player.OnPlay";
        public final Data data;

        public Play(ObjectNode objectNode) {
            super(objectNode);
            this.data = new Data((ObjectNode)objectNode.get("data"));
        }

        public String toString() {
            return "PLAY: Item " + this.data.item + " with player " + this.data.player.playerId + " at speed " + this.data.player.speed + ".";
        }

        @Override
        public int getId() {
            return 1;
        }

        @Override
        public String getMethod() {
            return METHOD;
        }
    }
}

