/*
 * Decompiled with CFR 0.152.
 */
package com.uwetrottmann.tmdb2.entities;

import com.uwetrottmann.tmdb2.enumerations.ReleaseType;
import javax.annotation.Nonnull;

public class DiscoverFilter {
    @Nonnull
    private final Separator separator;
    @Nonnull
    private final Integer[] items;

    public DiscoverFilter(Integer ... items) {
        this(Separator.AND, items);
    }

    public DiscoverFilter(@Nonnull Separator separator, Integer ... items) {
        this.separator = separator;
        this.items = items;
    }

    public DiscoverFilter(@Nonnull Separator separator, ReleaseType ... types) {
        this.separator = separator;
        this.items = new Integer[types.length];
        for (int i = 0; i < types.length; ++i) {
            ReleaseType type = types[i];
            if (type == null) continue;
            this.items[i] = type.id;
        }
    }

    public String toString() {
        if (this.separator == null || this.items == null || this.items.length == 0) {
            return null;
        }
        StringBuilder sb = new StringBuilder();
        for (Integer item : this.items) {
            if (item == null) continue;
            if (sb.length() > 0) {
                sb.append(this.separator.symbol);
            }
            sb.append(item);
        }
        return sb.toString();
    }

    public static enum Separator {
        AND(","),
        OR("|");

        private final String symbol;

        private Separator(String symbol) {
            this.symbol = symbol;
        }
    }
}

