/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.jcajce.provider.asymmetric.rsa;

import java.security.AlgorithmParameters;
import java.security.InvalidKeyException;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.SignatureException;
import java.security.SignatureSpi;
import java.security.interfaces.RSAPrivateKey;
import java.security.interfaces.RSAPublicKey;
import java.security.spec.AlgorithmParameterSpec;

public class DigestSignatureSpi
extends SignatureSpi {
    private \u050e digest;
    private \u1e86 cipher;
    private \u13cd algId;

    protected DigestSignatureSpi(\u050e \u050f2, \u1e86 \u1e872) {
        this.digest = \u050f2;
        this.cipher = \u1e872;
        this.algId = null;
    }

    protected DigestSignatureSpi(\u0399 \u03b92, \u050e \u050f2, \u1e86 \u1e872) {
        this.digest = \u050f2;
        this.cipher = \u1e872;
        this.algId = new \u13cd(\u03b92, \u0445.\u0495);
    }

    @Override
    protected void engineInitVerify(PublicKey object) {
        if (!(object instanceof RSAPublicKey)) {
            throw new InvalidKeyException("Supplied key (" + this.getType(object) + ") is not a RSAPublicKey instance");
        }
        object = \u053c.\u0495((RSAPublicKey)object);
        this.digest.\u0495();
        this.cipher.\u0495(false, (\u1e6f)object);
    }

    @Override
    protected void engineInitSign(PrivateKey object) {
        if (!(object instanceof RSAPrivateKey)) {
            throw new InvalidKeyException("Supplied key (" + this.getType(object) + ") is not a RSAPrivateKey instance");
        }
        object = \u053c.\u0495((RSAPrivateKey)object);
        this.digest.\u0495();
        this.cipher.\u0495(true, (\u1e6f)object);
    }

    private String getType(Object object) {
        if (object == null) {
            return null;
        }
        return object.getClass().getName();
    }

    @Override
    protected void engineUpdate(byte by) {
        this.digest.\u0495(by);
    }

    @Override
    protected void engineUpdate(byte[] byArray, int n, int n2) {
        this.digest.\u0495(byArray, n, n2);
    }

    @Override
    protected byte[] engineSign() {
        byte[] byArray = new byte[this.digest.\u0495()];
        this.digest.\u0495(byArray, 0);
        try {
            byArray = this.derEncode(byArray);
            return this.cipher.\u0495(byArray, 0, byArray.length);
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            throw new SignatureException("key too small for signature type");
        }
        catch (Exception exception) {
            throw new SignatureException(exception.toString());
        }
    }

    @Override
    protected boolean engineVerify(byte[] byArray) {
        byte[] byArray2 = new byte[this.digest.\u0495()];
        this.digest.\u0495(byArray2, 0);
        try {
            byArray = this.cipher.\u0495(byArray, 0, byArray.length);
            byArray2 = this.derEncode(byArray2);
        }
        catch (Exception exception) {
            return false;
        }
        if (byArray.length == byArray2.length) {
            return \u1f15.\u0494(byArray, byArray2);
        }
        if (byArray.length == byArray2.length - 2) {
            int n;
            byArray2[1] = (byte)(byArray2[1] - 2);
            byArray2[3] = (byte)(byArray2[3] - 2);
            int n2 = 4 + byArray2[3];
            int n3 = n2 + 2;
            int n4 = 0;
            for (n = 0; n < byArray2.length - n3; ++n) {
                n4 |= byArray[n2 + n] ^ byArray2[n3 + n];
            }
            for (n = 0; n < n2; ++n) {
                n4 |= byArray[n] ^ byArray2[n];
            }
            return n4 == 0;
        }
        \u1f15.\u0494(byArray2, byArray2);
        return false;
    }

    @Override
    protected void engineSetParameter(AlgorithmParameterSpec algorithmParameterSpec) {
        throw new UnsupportedOperationException("engineSetParameter unsupported");
    }

    @Override
    protected void engineSetParameter(String string, Object object) {
        throw new UnsupportedOperationException("engineSetParameter unsupported");
    }

    @Override
    protected Object engineGetParameter(String string) {
        return null;
    }

    @Override
    protected AlgorithmParameters engineGetParameters() {
        return null;
    }

    private byte[] derEncode(byte[] byArray) {
        if (this.algId == null) {
            return byArray;
        }
        return new \uab9d(this.algId, byArray).\u0495("DER");
    }
}

