/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.jcajce.provider.asymmetric.rsa;

import java.io.IOException;
import java.security.InvalidKeyException;
import java.security.Key;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.interfaces.RSAPrivateCrtKey;
import java.security.interfaces.RSAPrivateKey;
import java.security.interfaces.RSAPublicKey;
import java.security.spec.InvalidKeySpecException;
import java.security.spec.KeySpec;
import java.security.spec.PKCS8EncodedKeySpec;
import java.security.spec.RSAPrivateCrtKeySpec;
import java.security.spec.RSAPrivateKeySpec;
import java.security.spec.RSAPublicKeySpec;

public class KeyFactorySpi
extends \u056c {
    @Override
    public KeySpec engineGetKeySpec(Key key, Class clazz) {
        if (clazz.isAssignableFrom(RSAPublicKeySpec.class) && key instanceof RSAPublicKey) {
            key = (RSAPublicKey)key;
            return new RSAPublicKeySpec(key.getModulus(), key.getPublicExponent());
        }
        if (clazz.isAssignableFrom(RSAPrivateKeySpec.class) && key instanceof RSAPrivateKey) {
            key = (RSAPrivateKey)key;
            return new RSAPrivateKeySpec(key.getModulus(), key.getPrivateExponent());
        }
        if (clazz.isAssignableFrom(RSAPrivateCrtKeySpec.class) && key instanceof RSAPrivateCrtKey) {
            key = (RSAPrivateCrtKey)key;
            return new RSAPrivateCrtKeySpec(key.getModulus(), key.getPublicExponent(), key.getPrivateExponent(), key.getPrimeP(), key.getPrimeQ(), key.getPrimeExponentP(), key.getPrimeExponentQ(), key.getCrtCoefficient());
        }
        if (clazz.isAssignableFrom(\uff59.class) && key instanceof RSAPublicKey) {
            try {
                return new \uff59(\u03c5.\u0495(new \u2c73(false, ((RSAPublicKey)key).getModulus(), ((RSAPublicKey)key).getPublicExponent())));
            }
            catch (IOException iOException) {
                throw new IllegalArgumentException("unable to produce encoding: " + iOException.getMessage());
            }
        }
        if (clazz.isAssignableFrom(\u2c3f.class) && key instanceof RSAPrivateCrtKey) {
            try {
                return new \u2c3f(\u10af.\u0495(new \u0442(((RSAPrivateCrtKey)key).getModulus(), ((RSAPrivateCrtKey)key).getPublicExponent(), ((RSAPrivateCrtKey)key).getPrivateExponent(), ((RSAPrivateCrtKey)key).getPrimeP(), ((RSAPrivateCrtKey)key).getPrimeQ(), ((RSAPrivateCrtKey)key).getPrimeExponentP(), ((RSAPrivateCrtKey)key).getPrimeExponentQ(), ((RSAPrivateCrtKey)key).getCrtCoefficient())));
            }
            catch (IOException iOException) {
                throw new IllegalArgumentException("unable to produce encoding: " + iOException.getMessage());
            }
        }
        if (clazz.isAssignableFrom(\ua756.class) && key instanceof RSAPublicKey) {
            try {
                return new \ua756(\u03c5.\u0495(new \u2c73(false, ((RSAPublicKey)key).getModulus(), ((RSAPublicKey)key).getPublicExponent())));
            }
            catch (IOException iOException) {
                throw new IllegalArgumentException("unable to produce encoding: " + iOException.getMessage());
            }
        }
        if (clazz.isAssignableFrom(\ua757.class) && key instanceof RSAPrivateCrtKey) {
            try {
                return new \ua757(\u10af.\u0495(new \u0442(((RSAPrivateCrtKey)key).getModulus(), ((RSAPrivateCrtKey)key).getPublicExponent(), ((RSAPrivateCrtKey)key).getPrivateExponent(), ((RSAPrivateCrtKey)key).getPrimeP(), ((RSAPrivateCrtKey)key).getPrimeQ(), ((RSAPrivateCrtKey)key).getPrimeExponentP(), ((RSAPrivateCrtKey)key).getPrimeExponentQ(), ((RSAPrivateCrtKey)key).getCrtCoefficient())));
            }
            catch (IOException iOException) {
                throw new IllegalArgumentException("unable to produce encoding: " + iOException.getMessage());
            }
        }
        return super.engineGetKeySpec(key, clazz);
    }

    @Override
    protected Key engineTranslateKey(Key key) {
        if (key instanceof RSAPublicKey) {
            return new \u1ef1((RSAPublicKey)key);
        }
        if (key instanceof RSAPrivateCrtKey) {
            return new \u0372((RSAPrivateCrtKey)key);
        }
        if (key instanceof RSAPrivateKey) {
            return new \u1ef0((RSAPrivateKey)key);
        }
        throw new InvalidKeyException("key type unknown");
    }

    @Override
    public PrivateKey engineGeneratePrivate(KeySpec keySpec) {
        if (keySpec instanceof PKCS8EncodedKeySpec) {
            try {
                return this.generatePrivate(\u0460.\u0495(((PKCS8EncodedKeySpec)keySpec).getEncoded()));
            }
            catch (Exception exception) {
                try {
                    return new \u0372(\u0461.\u0495(((PKCS8EncodedKeySpec)keySpec).getEncoded()));
                }
                catch (Exception exception2) {
                    throw new \u1efb("unable to process key spec: " + exception.toString(), exception);
                }
            }
        }
        if (keySpec instanceof RSAPrivateCrtKeySpec) {
            return new \u0372((RSAPrivateCrtKeySpec)keySpec);
        }
        if (keySpec instanceof RSAPrivateKeySpec) {
            return new \u1ef0((RSAPrivateKeySpec)keySpec);
        }
        if (keySpec instanceof \u2c3f) {
            \u13aa \uab7a2 = \u10af.\u0495(((\u2c3f)keySpec).getEncoded());
            if (\uab7a2 instanceof \u0442) {
                return new \u0372((\u0442)\uab7a2);
            }
            throw new InvalidKeySpecException("open SSH public key is not RSA private key");
        }
        throw new InvalidKeySpecException("unknown KeySpec type: " + keySpec.getClass().getName());
    }

    @Override
    public PublicKey engineGeneratePublic(KeySpec object) {
        if (object instanceof RSAPublicKeySpec) {
            return new \u1ef1((RSAPublicKeySpec)object);
        }
        if (object instanceof \uff59) {
            if ((object = \u03c5.\u0495(((\uff59)object).getEncoded())) instanceof \u2c73) {
                return new \u1ef1((\u2c73)object);
            }
            throw new InvalidKeySpecException("Open SSH public key is not RSA public key");
        }
        return super.engineGeneratePublic((KeySpec)object);
    }

    @Override
    public PrivateKey generatePrivate(\u0460 \u04612) {
        \u03b9 \u03b92 = \u04612.\u0495.\u0495;
        if (\u053c.\u0495(\u03b92)) {
            \u03b92 = \u0461.\u0495(\u04612.\u0495());
            if (((\u0461)\u03b92).\u0147.intValue() == 0) {
                return new \u1ef0(\u04612.\u0495, (\u0461)\u03b92);
            }
            return new \u0372(\u04612);
        }
        throw new IOException("algorithm identifier " + \u03b92 + " in key not recognised");
    }

    @Override
    public PublicKey generatePublic(\uab8d \uab8d2) {
        \u0399 \u03b92 = \uab8d2.\u0495.\u0495;
        if (\u053c.\u0495(\u03b92)) {
            return new \u1ef1(\uab8d2);
        }
        throw new IOException("algorithm identifier " + \u03b92 + " in key not recognised");
    }
}

