/*
 * Decompiled with CFR 0.152.
 */
package com.github.kiulian.downloader.model;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import java.util.ArrayList;
import java.util.List;

public abstract class AbstractVideoDetails {
    protected String videoId;
    private int lengthSeconds;
    private List<String> thumbnails;
    protected String title;
    protected String author;
    protected boolean isLive;

    protected boolean isDownloadable() {
        return !this.isLive() && this.lengthSeconds() != 0;
    }

    public AbstractVideoDetails() {
    }

    public AbstractVideoDetails(JSONObject jSONObject) {
        this.videoId = jSONObject.getString("videoId");
        this.lengthSeconds = jSONObject.getIntValue("lengthSeconds");
        JSONArray jSONArray = jSONObject.getJSONObject("thumbnail").getJSONArray("thumbnails");
        this.thumbnails = new ArrayList<String>(jSONArray.size());
        for (int i = 0; i < jSONArray.size(); ++i) {
            JSONObject jSONObject2 = jSONArray.getJSONObject(i);
            if (!jSONObject2.containsKey("url")) continue;
            this.thumbnails.add(jSONObject2.getString("url"));
        }
    }

    public String videoId() {
        return this.videoId;
    }

    public String title() {
        return this.title;
    }

    public int lengthSeconds() {
        return this.lengthSeconds;
    }

    public List<String> thumbnails() {
        return this.thumbnails;
    }

    public String author() {
        return this.author;
    }

    public boolean isLive() {
        return this.isLive;
    }
}

