/*
 * Decompiled with CFR 0.152.
 */
package okhttp3.brotli;

import java.io.InputStream;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import okhttp3.Interceptor;
import okhttp3.Request;
import okhttp3.Response;
import okhttp3.ResponseBody;
import okhttp3.internal.http.HttpHeaders;
import okio.BufferedSource;
import okio.GzipSource;
import okio.Okio;
import okio.Source;
import org.brotli.dec.BrotliInputStream;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0016J\u0015\u0010\u0007\u001a\u00020\u00042\u0006\u0010\b\u001a\u00020\u0004H\u0000\u00a2\u0006\u0002\b\t\u00a8\u0006\n"}, d2={"Lokhttp3/brotli/BrotliInterceptor;", "Lokhttp3/Interceptor;", "()V", "intercept", "Lokhttp3/Response;", "chain", "Lokhttp3/Interceptor$Chain;", "uncompress", "response", "uncompress$okhttp_brotli", "okhttp-brotli"})
public final class BrotliInterceptor
implements Interceptor {
    @NotNull
    public static final BrotliInterceptor INSTANCE = new BrotliInterceptor();

    private BrotliInterceptor() {
    }

    @NotNull
    public Response intercept(@NotNull Interceptor.Chain chain) {
        Response response;
        Intrinsics.checkNotNullParameter((Object)chain, (String)"chain");
        if (chain.request().header("Accept-Encoding") == null) {
            Request request = chain.request().newBuilder().header("Accept-Encoding", "br,gzip").build();
            Response response2 = chain.proceed(request);
            response = this.uncompress$okhttp_brotli(response2);
        } else {
            response = chain.proceed(chain.request());
        }
        return response;
    }

    @NotNull
    public final Response uncompress$okhttp_brotli(@NotNull Response response) {
        BufferedSource bufferedSource;
        Intrinsics.checkNotNullParameter((Object)response, (String)"response");
        if (!HttpHeaders.promisesBody((Response)response)) {
            return response;
        }
        ResponseBody responseBody = response.body();
        if (responseBody == null) {
            return response;
        }
        ResponseBody body = responseBody;
        String string = Response.header$default((Response)response, (String)"Content-Encoding", null, (int)2, null);
        if (string == null) {
            return response;
        }
        String encoding = string;
        if (StringsKt.equals((String)encoding, (String)"br", (boolean)true)) {
            bufferedSource = Okio.buffer((Source)Okio.source((InputStream)((InputStream)new BrotliInputStream(body.source().inputStream()))));
        } else if (StringsKt.equals((String)encoding, (String)"gzip", (boolean)true)) {
            bufferedSource = Okio.buffer((Source)((Source)new GzipSource((Source)body.source())));
        } else {
            return response;
        }
        BufferedSource decompressedSource = bufferedSource;
        return response.newBuilder().removeHeader("Content-Encoding").removeHeader("Content-Length").body(ResponseBody.Companion.create(decompressedSource, body.contentType(), -1L)).build();
    }
}

