/*
 * Decompiled with CFR 0.152.
 */
package org.tinymediamanager.library.bluray.clipinf;

import jakarta.xml.bind.annotation.XmlType;
import jakarta.xml.bind.annotation.adapters.XmlJavaTypeAdapter;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.tinymediamanager.library.bluray.clipinf.HexStringByteAdapter;
import org.tinymediamanager.library.bluray.clipinf.StringIOHelper;

@XmlType(propOrder={"streamPID", "const0x15", "attr", "unknownvalue1", "name"})
public class Subtitle {
    private static final Logger LOGGER = LoggerFactory.getLogger(Subtitle.class);
    private short streamPID;
    private Byte const0x15;
    private Byte attr;
    private int unknownvalue1;
    private String name;

    public short getStreamPID() {
        return this.streamPID;
    }

    public void setStreamPID(short s) {
        this.streamPID = s;
    }

    @XmlJavaTypeAdapter(value=HexStringByteAdapter.class)
    public Byte getConst0x15() {
        return this.const0x15;
    }

    public void setConst0x15(Byte by) {
        this.const0x15 = by;
    }

    @XmlJavaTypeAdapter(value=HexStringByteAdapter.class)
    public Byte getAttr() {
        return this.attr;
    }

    public void setAttr(Byte by) {
        this.attr = by;
    }

    public int getUnknownvalue1() {
        return this.unknownvalue1;
    }

    public void setUnknownvalue1(int n) {
        this.unknownvalue1 = n;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String string) {
        this.name = string;
    }

    public void readObject(DataInputStream dataInputStream) throws IOException {
        this.streamPID = dataInputStream.readShort();
        LOGGER.trace("Subtitle streamPID={}", (Object)this.streamPID);
        this.const0x15 = dataInputStream.readByte();
        LOGGER.trace("Subtitle const0x15={}", (Object)this.const0x15);
        this.attr = dataInputStream.readByte();
        LOGGER.trace("Subtitle attr={}", (Object)this.attr);
        this.unknownvalue1 = dataInputStream.readInt();
        LOGGER.trace("Subtitle unknown1={}", (Object)this.unknownvalue1);
        this.name = StringIOHelper.readISO646String(dataInputStream, 12);
        LOGGER.trace("Subtitle name={}", (Object)this.name);
        dataInputStream.skipBytes(4);
    }

    public void writeObject(DataOutputStream dataOutputStream) throws IOException {
        dataOutputStream.writeShort(this.getStreamPID());
        dataOutputStream.write(this.getConst0x15().byteValue());
        dataOutputStream.write(this.getAttr().byteValue());
        dataOutputStream.writeInt(this.getUnknownvalue1());
        dataOutputStream.write(StringIOHelper.getISO646Bytes(this.getName()));
        for (int i = 0; i < 4; ++i) {
            dataOutputStream.write(0);
        }
    }
}

