/*
 * Decompiled with CFR 0.152.
 */
package com.threerings.getdown;

import java.io.PrintWriter;
import java.io.StringWriter;
import java.text.FieldPosition;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.logging.Formatter;
import java.util.logging.Handler;
import java.util.logging.Level;
import java.util.logging.LogManager;
import java.util.logging.LogRecord;
import java.util.logging.Logger;

public final class Log {
    public static final Shim log = new Shim();
    protected static final Level[] LEVELS;

    public static String format(Object message, Object ... args) {
        if (args.length < 2) {
            return String.valueOf(message);
        }
        StringBuilder buf = new StringBuilder(String.valueOf(message));
        if (buf.length() > 0) {
            buf.append(' ');
        }
        buf.append('[');
        int ll = args.length / 2;
        for (int ii = 0; ii < ll; ++ii) {
            if (ii > 0) {
                buf.append(',').append(' ');
            }
            buf.append(args[2 * ii]).append('=');
            try {
                buf.append(args[2 * ii + 1]);
                continue;
            }
            catch (Throwable t) {
                buf.append("<toString() failure: ").append(t).append(">");
            }
        }
        return buf.append(']').toString();
    }

    static {
        OneLineFormatter formatter = new OneLineFormatter();
        Logger logger = LogManager.getLogManager().getLogger("");
        for (Handler handler : logger.getHandlers()) {
            handler.setFormatter(formatter);
        }
        LEVELS = new Level[]{Level.FINE, Level.INFO, Level.WARNING, Level.SEVERE};
    }

    protected static class OneLineFormatter
    extends Formatter {
        protected Date _date = new Date();
        protected SimpleDateFormat _format = new SimpleDateFormat("yyyy/MM/dd HH:mm:ss:SSS");
        protected FieldPosition _fpos = new FieldPosition(3);

        protected OneLineFormatter() {
        }

        @Override
        public String format(LogRecord record) {
            StringBuffer buf = new StringBuffer();
            this._date.setTime(record.getMillis());
            this._format.format(this._date, buf, this._fpos);
            buf.append(" ");
            buf.append(record.getLevel().getLocalizedName());
            buf.append(" ");
            buf.append(this.formatMessage(record));
            buf.append(System.lineSeparator());
            if (record.getThrown() != null) {
                try {
                    StringWriter sw = new StringWriter();
                    PrintWriter pw = new PrintWriter(sw);
                    record.getThrown().printStackTrace(pw);
                    pw.close();
                    buf.append(sw.toString());
                }
                catch (Exception ex) {
                    buf.append("Format failure:").append(ex);
                }
            }
            return buf.toString();
        }
    }

    public static class Shim {
        protected final Logger _impl = Logger.getLogger("com.threerings.getdown");

        public void debug(Object message, Object ... args) {
            this.doLog(0, message, args);
        }

        public void info(Object message, Object ... args) {
            this.doLog(1, message, args);
        }

        public void warning(Object message, Object ... args) {
            this.doLog(2, message, args);
        }

        public void error(Object message, Object ... args) {
            this.doLog(3, message, args);
        }

        protected void doLog(int levIdx, Object message, Object[] args) {
            if (this._impl.isLoggable(LEVELS[levIdx])) {
                Throwable err = null;
                int nn = args.length;
                if (message instanceof Throwable) {
                    err = (Throwable)message;
                } else if (nn % 2 == 1 && args[nn - 1] instanceof Throwable) {
                    err = (Throwable)args[--nn];
                }
                this._impl.log(LEVELS[levIdx], Log.format(message, args), err);
            }
        }
    }
}

