/*
 * Decompiled with CFR 0.152.
 */
package com.threerings.getdown.net;

import com.threerings.getdown.data.SysProps;
import com.threerings.getdown.util.Base64;
import com.threerings.getdown.util.StreamUtil;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.HttpURLConnection;
import java.net.InetSocketAddress;
import java.net.Proxy;
import java.net.URL;
import java.net.URLConnection;
import java.net.URLDecoder;
import java.nio.charset.StandardCharsets;
import java.util.List;
import java.util.zip.GZIPInputStream;

public class Connector {
    public static final Connector DEFAULT = new Connector(Proxy.NO_PROXY);
    public final Proxy proxy;
    public State state = State.ACTIVE;

    public Connector(Proxy proxy) {
        this.proxy = proxy;
    }

    public URLConnection open(URL url, int connectTimeout, int readTimeout) throws IOException {
        String userInfo;
        int rtimeout;
        int ctimeout;
        URLConnection conn = url.openConnection(this.proxy);
        int n = ctimeout = connectTimeout > 0 ? connectTimeout : SysProps.connectTimeout();
        if (ctimeout > 0) {
            conn.setConnectTimeout(ctimeout * 1000);
        }
        int n2 = rtimeout = readTimeout > 0 ? readTimeout : SysProps.readTimeout();
        if (rtimeout > 0) {
            conn.setReadTimeout(rtimeout * 1000);
        }
        if ((userInfo = url.getUserInfo()) != null) {
            userInfo = URLDecoder.decode(userInfo, "UTF-8");
            String encoded = Base64.encodeToString(userInfo.getBytes(StandardCharsets.UTF_8), 0).replaceAll("\\n", "").replaceAll("\\r", "");
            conn.setRequestProperty("Authorization", "Basic " + encoded);
        }
        return conn;
    }

    public HttpURLConnection openHttp(URL url, int connectTimeout, int readTimeout) throws IOException {
        return (HttpURLConnection)this.open(url, connectTimeout, readTimeout);
    }

    public void download(URL url, File target) throws IOException {
        URLConnection conn = this.open(url, 0, 0);
        conn.setUseCaches(false);
        conn.setRequestProperty("Accept-Encoding", "gzip");
        this.checkConnectOK(conn, "Unable to download " + url);
        try (InputStream fin = conn.getInputStream();){
            String encoding = conn.getContentEncoding();
            boolean gzip = "gzip".equalsIgnoreCase(encoding);
            try (InputStream fin2 = gzip ? new GZIPInputStream(fin) : fin;
                 FileOutputStream fout = new FileOutputStream(target);){
                StreamUtil.copy(fin2, fout);
            }
        }
    }

    public String fetch(URL url) throws IOException {
        URLConnection conn = this.open(url, 0, 0);
        this.checkConnectOK(conn, "Unable to fetch " + url);
        int size = conn.getContentLength();
        ByteArrayOutputStream out = new ByteArrayOutputStream(size > 0 ? size : 1024);
        try (InputStream in = conn.getInputStream();){
            StreamUtil.copy(in, out);
        }
        return out.toString(StandardCharsets.UTF_8.toString());
    }

    public void checkConnectOK(URLConnection conn, String errpre) throws IOException {
        if (!(conn instanceof HttpURLConnection)) {
            return;
        }
        int code = ((HttpURLConnection)conn).getResponseCode();
        switch (code) {
            case 200: {
                return;
            }
            case 305: 
            case 403: {
                this.state = State.NEED_PROXY;
                break;
            }
            case 407: {
                this.state = State.NEED_PROXY_AUTH;
            }
        }
        throw new IOException(errpre + " [code=" + code + "]");
    }

    public void addProxyArgs(List<String> args) {
        if (this.proxy.type() == Proxy.Type.HTTP && this.proxy.address() instanceof InetSocketAddress) {
            InetSocketAddress proxyAddr = (InetSocketAddress)this.proxy.address();
            String proxyHost = proxyAddr.getHostString();
            int proxyPort = proxyAddr.getPort();
            args.add("-Dhttp.proxyHost=" + proxyHost);
            args.add("-Dhttp.proxyPort=" + proxyPort);
            args.add("-Dhttps.proxyHost=" + proxyHost);
            args.add("-Dhttps.proxyPort=" + proxyPort);
        }
    }

    public static enum State {
        ACTIVE,
        NEED_PROXY,
        NEED_PROXY_AUTH;

    }
}

